/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.saml.persist.internal.orient;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.ORecordDuplicatedException;
import com.sonatype.nexus.saml.persist.entity.SamlUser;
import com.sonatype.nexus.saml.persist.internal.SamlUserStore;
import com.sonatype.nexus.saml.persist.internal.SamlUserUtil;
import com.sonatype.nexus.saml.persist.internal.orient.OrientSamlUser;
import com.sonatype.nexus.saml.persist.internal.orient.OrientSamlUserEntityAdapter;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.transaction.OrientTransactional;
import org.sonatype.nexus.security.user.User;
import org.sonatype.nexus.security.user.UserSearchCriteria;

@Named(value="orient")
@Priority(value=0x7FFFFFFF)
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SCHEMAS)
@Singleton
public class OrientSamlUserStore
extends StateGuardLifecycleSupport
implements SamlUserStore {
    private final Provider<DatabaseInstance> databaseInstance;
    private final OrientSamlUserEntityAdapter entityAdapter;

    @Inject
    public OrientSamlUserStore(@Named(value="security") @Named(value="security") Provider<DatabaseInstance> databaseInstance, OrientSamlUserEntityAdapter entityAdapter) {
        this.databaseInstance = (Provider)Preconditions.checkNotNull(databaseInstance);
        this.entityAdapter = (OrientSamlUserEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)entityAdapter)));
    }

    protected void doStart() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).connect();){
            this.entityAdapter.register(db);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void create(SamlUser samlUser) {
        Preconditions.checkArgument((boolean)(samlUser instanceof OrientSamlUser), (Object)"Not an instance of OrientSamlUser");
        try {
            OrientTransactional.inTxRetry(this.databaseInstance).call(db -> {
                this.entityAdapter.addEntity(db, (Entity)((OrientSamlUser)samlUser));
                return samlUser.getId();
            });
        }
        catch (ORecordDuplicatedException e) {
            throw new IllegalArgumentException(String.format("Duplicated record: id=%s", samlUser.getId()), e);
        }
    }

    @Override
    public List<SamlUser> list() {
        return (List)OrientTransactional.inTx(this.databaseInstance).call(db -> ImmutableList.copyOf((Iterable)this.entityAdapter.browse(db)));
    }

    @Override
    public void deleteUser(String userId) {
        Preconditions.checkNotNull((Object)userId);
        this.log.trace("Removing user: {}", (Object)userId);
        try {
            OrientTransactional.inTxRetry(this.databaseInstance).call(db -> this.entityAdapter.delete(db, userId));
        }
        catch (OConcurrentModificationException e) {
            throw new ConcurrentModificationException("SamlUser '" + userId + "' updated in the meantime", e);
        }
    }

    @Override
    public Set<String> listUserIds() {
        return this.list().stream().map(SamlUser::getId).collect(Collectors.toSet());
    }

    @Override
    public SamlUser newEntity() {
        return this.entityAdapter.newEntity();
    }

    @Override
    public void update(User user) {
        SamlUser samlUser = this.toSamlUser(user);
        OrientTransactional.inTxRetry(this.databaseInstance).call(db -> {
            ODocument doc = this.entityAdapter.selectById(db, samlUser.getId());
            if (doc != null) {
                this.entityAdapter.writeEntity(doc, (Entity)((OrientSamlUser)samlUser));
                return true;
            }
            return false;
        });
    }

    @Override
    public Set<User> searchUsers(UserSearchCriteria criteria) {
        List<SamlUser> samlUsers = this.list();
        return SamlUserUtil.filterUsers(criteria, samlUsers);
    }

    @Override
    public SamlUser getUser(String userId) {
        return (SamlUser)OrientTransactional.inTx(this.databaseInstance).call(db -> this.entityAdapter.read(db, userId));
    }

    private SamlUser toSamlUser(User user) {
        OrientSamlUser samlUser = this.entityAdapter.newEntity();
        return SamlUserUtil.userToSamlUser(user, samlUser);
    }
}

