/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.saml.persist.internal.orient;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.sonatype.nexus.saml.persist.internal.orient.OrientSamlUser;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.OIndexNameBuilder;
import org.sonatype.nexus.orient.entity.EntityAdapter;
import org.sonatype.nexus.orient.entity.IterableEntityAdapter;
import org.sonatype.nexus.orient.entity.action.DeleteEntityByPropertyAction;
import org.sonatype.nexus.orient.entity.action.ReadEntityByPropertyAction;
import org.sonatype.nexus.orient.entity.action.UpdateEntityByPropertyAction;

@Named
@Singleton
public class OrientSamlUserEntityAdapter
extends IterableEntityAdapter<OrientSamlUser> {
    private static final String DB_CLASS = new OClassNameBuilder().type("saml_user").build();
    private static final String P_ID = "id";
    private static final String P_FIRST_NAME = "firstName";
    private static final String P_LAST_NAME = "lastName";
    private static final String P_STATUS = "status";
    private static final String P_EMAIL = "email";
    private static final String P_ROLES = "roles";
    private static final String I_ID = new OIndexNameBuilder().type(DB_CLASS).property("id").build();
    private final ReadEntityByPropertyAction<OrientSamlUser> readEntity = new ReadEntityByPropertyAction((EntityAdapter)this, new String[]{"id"});
    private final DeleteEntityByPropertyAction delete = new DeleteEntityByPropertyAction((EntityAdapter)this, new String[]{"id"});
    private final UpdateEntityByPropertyAction<OrientSamlUser> update = new UpdateEntityByPropertyAction((EntityAdapter)this, new String[]{"id"});

    public OrientSamlUserEntityAdapter() {
        super(DB_CLASS);
    }

    protected void defineType(OClass type) {
        type.createProperty(P_ID, OType.STRING).setNotNull(true);
        type.createProperty(P_FIRST_NAME, OType.STRING);
        type.createProperty(P_LAST_NAME, OType.STRING);
        type.createProperty(P_EMAIL, OType.STRING);
        type.createProperty(P_STATUS, OType.STRING).setNotNull(true);
        type.createProperty(P_ROLES, OType.EMBEDDEDSET).setNotNull(true);
        type.createIndex(I_ID, OClass.INDEX_TYPE.UNIQUE, new String[]{P_ID});
    }

    protected OrientSamlUser newEntity() {
        return new OrientSamlUser();
    }

    protected void readFields(ODocument document, OrientSamlUser entity) throws Exception {
        entity.setId((String)document.field(P_ID, OType.STRING));
        entity.setFirstName((String)document.field(P_FIRST_NAME, OType.STRING));
        entity.setLastName((String)document.field(P_LAST_NAME, OType.STRING));
        entity.setEmail((String)document.field(P_EMAIL, OType.STRING));
        entity.setStatus((String)document.field(P_STATUS, OType.STRING));
        entity.setRoles((Set)document.field(P_ROLES, OType.EMBEDDEDSET));
    }

    protected void writeFields(ODocument document, OrientSamlUser entity) throws Exception {
        document.field(P_ID, (Object)entity.getId());
        document.field(P_FIRST_NAME, (Object)entity.getFirstName());
        document.field(P_LAST_NAME, (Object)entity.getLastName());
        document.field(P_EMAIL, (Object)entity.getEmail());
        document.field(P_STATUS, (Object)entity.getStatus());
        document.field(P_ROLES, entity.getRoles());
    }

    public ODocument selectById(ODatabaseDocumentTx db, String id) {
        Preconditions.checkNotNull((Object)db);
        Preconditions.checkNotNull((Object)id);
        List results = (List)db.command(this.selectAllById()).execute(new Object[]{id});
        return results.stream().findFirst().orElse(null);
    }

    private OSQLSynchQuery<ODocument> selectAllById() {
        return new OSQLSynchQuery(String.format("SELECT FROM %s WHERE %s = ?", DB_CLASS, P_ID));
    }

    @Nullable
    public OrientSamlUser read(ODatabaseDocumentTx db, String id) {
        return (OrientSamlUser)this.readEntity.execute(db, new Object[]{id});
    }

    public boolean delete(ODatabaseDocumentTx db, String id) {
        return this.delete.execute(db, new Object[]{id});
    }

    public boolean update(ODatabaseDocumentTx db, OrientSamlUser entity) {
        return this.update.execute(db, (Entity)entity, new Object[]{entity.getId()});
    }
}

