/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.saml.persist.internal.orient;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.ORecordDuplicatedException;
import com.sonatype.nexus.saml.persist.SamlConfigurationException;
import com.sonatype.nexus.saml.persist.entity.SamlConfiguration;
import com.sonatype.nexus.saml.persist.internal.SamlConfigurationStore;
import com.sonatype.nexus.saml.persist.internal.orient.OrientSamlConfiguration;
import com.sonatype.nexus.saml.persist.internal.orient.OrientSamlConfigurationEntityAdapter;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.transaction.OrientTransactional;

@Named(value="orient")
@Priority(value=0x7FFFFFFF)
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SCHEMAS)
@Singleton
public class OrientSamlConfigurationStore
extends StateGuardLifecycleSupport
implements SamlConfigurationStore {
    private final Provider<DatabaseInstance> databaseInstance;
    private final OrientSamlConfigurationEntityAdapter entityAdapter;

    @Inject
    public OrientSamlConfigurationStore(@Named(value="config") @Named(value="config") Provider<DatabaseInstance> databaseInstance, OrientSamlConfigurationEntityAdapter entityAdapter) {
        this.databaseInstance = (Provider)Preconditions.checkNotNull(databaseInstance);
        this.entityAdapter = (OrientSamlConfigurationEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)entityAdapter)));
    }

    protected void doStart() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).connect();){
            this.entityAdapter.register(db);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Nullable
    @Guarded(by={"STARTED"})
    public SamlConfiguration load() {
        return this.loadAll().stream().findFirst().orElse(null);
    }

    @Override
    @Guarded(by={"STARTED"})
    public synchronized void create(SamlConfiguration configuration) {
        Preconditions.checkArgument((boolean)(configuration instanceof OrientSamlConfiguration), (Object)"Not an instance of OrientSamlConfiguration");
        if (this.load() != null) {
            throw new SamlConfigurationException("Can only have one SAML configuration.");
        }
        try {
            OrientTransactional.inTxRetry(this.databaseInstance).call(db -> {
                configuration.setId(UUID.randomUUID().toString());
                this.entityAdapter.addEntity(db, (Entity)((OrientSamlConfiguration)configuration));
                return configuration.getId();
            });
        }
        catch (ORecordDuplicatedException e) {
            throw new IllegalArgumentException(String.format("Duplicated record: id=%s , entityId=%s", configuration.getId(), configuration.getEntityId()), e);
        }
    }

    @Override
    @Guarded(by={"STARTED"})
    public void update(SamlConfiguration configuration) {
        Preconditions.checkArgument((boolean)(configuration instanceof OrientSamlConfiguration), (Object)"Not an instance of OrientSamlConfiguration");
        try {
            OrientTransactional.inTxRetry(this.databaseInstance).call(db -> {
                ODocument doc = this.entityAdapter.selectById(db, configuration.getId());
                if (doc != null) {
                    this.entityAdapter.writeEntity(doc, (Entity)((OrientSamlConfiguration)configuration));
                    return true;
                }
                return false;
            });
        }
        catch (OConcurrentModificationException e) {
            throw new IllegalArgumentException(String.format("Stale update attempt id=%s, entityId=%s", configuration.getId(), configuration.getEntityId()), e);
        }
    }

    @Override
    @Guarded(by={"STARTED"})
    public void delete(String id) {
        OrientTransactional.inTxRetry(this.databaseInstance).call(db -> {
            ODocument doc = this.entityAdapter.selectById(db, id);
            if (doc != null) {
                db.delete((ORecord)doc);
                return true;
            }
            return false;
        });
    }

    @Override
    public SamlConfiguration newEntity() {
        return new OrientSamlConfiguration();
    }

    private List<SamlConfiguration> loadAll() {
        return (List)OrientTransactional.inTx(this.databaseInstance).call(db -> ImmutableList.copyOf((Iterable)this.entityAdapter.browse(db)));
    }
}

