/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.saml.persist.internal;

import com.google.common.collect.ImmutableList;
import com.sonatype.nexus.saml.persist.entity.SamlUser;
import com.sonatype.nexus.saml.persist.internal.SamlUserDAO;
import com.sonatype.nexus.saml.persist.internal.SamlUserData;
import com.sonatype.nexus.saml.persist.internal.SamlUserStore;
import com.sonatype.nexus.saml.persist.internal.SamlUserUtil;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.datastore.ConfigStoreSupport;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.security.user.User;
import org.sonatype.nexus.security.user.UserSearchCriteria;
import org.sonatype.nexus.transaction.Transactional;

@Named(value="mybatis")
@Singleton
public class SamlUserStoreImpl
extends ConfigStoreSupport<SamlUserDAO>
implements SamlUserStore {
    @Inject
    public SamlUserStoreImpl(DataSessionSupplier sessionSupplier) {
        super(sessionSupplier);
    }

    @Override
    @Transactional
    public void create(SamlUser samlUser) {
        ((SamlUserDAO)this.dao()).create((SamlUserData)samlUser);
    }

    @Override
    @Transactional
    public List<SamlUser> list() {
        return ImmutableList.copyOf((Iterable)((SamlUserDAO)this.dao()).browse());
    }

    @Override
    @Transactional
    public void deleteUser(String userId) {
        ((SamlUserDAO)this.dao()).delete(userId);
    }

    @Override
    @Transactional
    public Set<String> listUserIds() {
        return ImmutableList.copyOf((Iterable)((SamlUserDAO)this.dao()).browse()).stream().map(SamlUser::getId).collect(Collectors.toSet());
    }

    @Override
    public SamlUser newEntity() {
        return new SamlUserData();
    }

    @Override
    @Transactional
    public SamlUser getUser(String userId) {
        return ((SamlUserDAO)this.dao()).read(userId).orElse(null);
    }

    @Override
    @Transactional
    public void update(User user) {
        ((SamlUserDAO)this.dao()).update((SamlUserData)this.toSamlUser(user));
    }

    @Override
    @Transactional
    public Set<User> searchUsers(UserSearchCriteria criteria) {
        List<SamlUser> samlUsers = this.list();
        return SamlUserUtil.filterUsers(criteria, samlUsers);
    }

    private SamlUser toSamlUser(User user) {
        SamlUser samlUser = this.newEntity();
        return SamlUserUtil.userToSamlUser(user, samlUser);
    }
}

