/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.saml.persist.internal;

import com.sonatype.nexus.saml.persist.entity.SamlUser;
import com.sonatype.nexus.saml.persist.internal.SamlUserData;
import com.sonatype.nexus.saml.persist.internal.SamlUserStore;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.supportzip.ExportSecurityData;
import org.sonatype.nexus.supportzip.ImportData;
import org.sonatype.nexus.supportzip.datastore.JsonExporter;

@Named(value="samlUserExport")
@Singleton
public class SamlUserExport
extends JsonExporter
implements ExportSecurityData,
ImportData {
    private final SamlUserStore store;

    @Inject
    public SamlUserExport(SamlUserStore store) {
        this.store = store;
    }

    public void export(File file) throws IOException {
        this.log.debug("Export SamlUser data to {}", (Object)file);
        List<SamlUser> samlUsers = this.store.list();
        this.exportToJson(samlUsers, file);
    }

    public void restore(File file) throws IOException {
        this.log.debug("Restoring SamlUser data from {}", (Object)file);
        this.importFromJson(file, SamlUserData.class).forEach(this.store::create);
    }
}

