/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.saml.persist.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.saml.events.SamlConfigurationChangedEvent;
import com.sonatype.nexus.saml.events.SamlConfigurationDTO;
import com.sonatype.nexus.saml.persist.entity.SamlConfiguration;
import com.sonatype.nexus.saml.persist.internal.SamlConfigurationDAO;
import com.sonatype.nexus.saml.persist.internal.SamlConfigurationData;
import com.sonatype.nexus.saml.persist.internal.SamlConfigurationStore;
import com.sonatype.nexus.saml.persist.internal.SamlSecurityHelper;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.datastore.ConfigStoreSupport;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.transaction.Transactional;

@Named(value="mybatis")
@Singleton
public class SamlConfigurationStoreImpl
extends ConfigStoreSupport<SamlConfigurationDAO>
implements SamlConfigurationStore {
    private final SamlSecurityHelper samlSecurityHelper;

    @Inject
    public SamlConfigurationStoreImpl(DataSessionSupplier sessionSupplier, SamlSecurityHelper samlSecurityHelper) {
        super(sessionSupplier);
        this.samlSecurityHelper = (SamlSecurityHelper)((Object)Preconditions.checkNotNull((Object)((Object)samlSecurityHelper)));
    }

    @Override
    @Nullable
    @Transactional
    public SamlConfiguration load() {
        SamlConfiguration configuration = ((SamlConfigurationDAO)this.dao()).get().orElse(null);
        if (configuration != null) {
            this.samlSecurityHelper.setKeyStore(configuration, configuration.getKeyStorePassword(), configuration.getKeyStoreBytes());
        }
        return configuration;
    }

    @Override
    @Transactional
    public void create(SamlConfiguration configuration) {
        if (configuration.getKeyStorePassword() == null && configuration.getKeyStoreBytes() == null) {
            this.samlSecurityHelper.newKeyStore(configuration);
        }
        SamlConfigurationDTO samlConfiguration = SamlConfigurationDTO.convert(configuration);
        SamlConfigurationChangedEvent configurationChangedEvent = new SamlConfigurationChangedEvent(samlConfiguration);
        this.postCommitEvent(() -> configurationChangedEvent);
        ((SamlConfigurationDAO)this.dao()).set((SamlConfigurationData)configuration);
    }

    @Override
    @Transactional
    public void update(SamlConfiguration configuration) {
        SamlConfigurationDTO samlConfiguration = SamlConfigurationDTO.convert(configuration);
        SamlConfigurationChangedEvent configurationChangedEvent = new SamlConfigurationChangedEvent(samlConfiguration);
        this.postCommitEvent(() -> configurationChangedEvent);
        ((SamlConfigurationDAO)this.dao()).set((SamlConfigurationData)configuration);
    }

    @Override
    @Transactional
    public void delete(String id) {
        SamlConfigurationChangedEvent configurationChangedEvent = new SamlConfigurationChangedEvent();
        this.postCommitEvent(() -> configurationChangedEvent);
        ((SamlConfigurationDAO)this.dao()).clear();
    }

    @Override
    public SamlConfiguration newEntity() {
        return new SamlConfigurationData();
    }
}

