/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.saml.persist.internal;

import com.sonatype.nexus.saml.persist.entity.SamlConfiguration;
import com.sonatype.nexus.saml.persist.internal.SamlConfigurationData;
import com.sonatype.nexus.saml.persist.internal.SamlConfigurationStore;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.supportzip.ExportConfigData;
import org.sonatype.nexus.supportzip.ImportData;
import org.sonatype.nexus.supportzip.datastore.JsonExporter;

@Named(value="samlConfigurationExport")
@Singleton
public class SamlConfigurationExport
extends JsonExporter
implements ExportConfigData,
ImportData {
    private final SamlConfigurationStore store;

    @Inject
    public SamlConfigurationExport(SamlConfigurationStore store) {
        this.store = store;
    }

    public void export(File file) throws IOException {
        this.log.debug("Export SamlConfiguration data to {}", (Object)file);
        SamlConfiguration configuration = this.store.load();
        this.exportObjectToJson(configuration, file);
    }

    public void restore(File file) throws IOException {
        this.log.debug("Restoring SamlConfiguration data from {}", (Object)file);
        Optional configuration = this.importObjectFromJson(file, SamlConfigurationData.class);
        configuration.ifPresent(this.store::create);
    }
}

