/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.saml.persist.internal;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.saml.events.SamlConfigurationChangedEvent;
import com.sonatype.nexus.saml.internal.SamlDeploymentManager;
import com.sonatype.nexus.saml.persist.SamlConfigurationException;
import com.sonatype.nexus.saml.persist.SamlConfigurationManager;
import com.sonatype.nexus.saml.persist.SamlConfigurationValidator;
import com.sonatype.nexus.saml.persist.entity.Mapping;
import com.sonatype.nexus.saml.persist.entity.SamlConfiguration;
import com.sonatype.nexus.saml.persist.internal.SamlConfigurationStore;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.BaseUrlHolder;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.security.realm.RealmManager;

@Named
@Singleton
public class DefaultSamlConfigurationManager
extends ComponentSupport
implements SamlConfigurationManager,
EventAware,
EventAware.Asynchronous {
    private final SamlConfigurationStore configurationStore;
    private final SamlConfigurationValidator configurationValidator;
    private final SamlDeploymentManager samlDeploymentManager;
    private final RealmManager realmManager;

    @Inject
    public DefaultSamlConfigurationManager(SamlConfigurationStore configurationStore, SamlConfigurationValidator configurationValidator, SamlDeploymentManager samlDeploymentManager, RealmManager realmManager) {
        this.configurationStore = (SamlConfigurationStore)Preconditions.checkNotNull((Object)configurationStore);
        this.configurationValidator = (SamlConfigurationValidator)Preconditions.checkNotNull((Object)configurationValidator);
        this.samlDeploymentManager = (SamlDeploymentManager)((Object)Preconditions.checkNotNull((Object)((Object)samlDeploymentManager)));
        this.realmManager = (RealmManager)Preconditions.checkNotNull((Object)realmManager);
    }

    @Override
    public SamlConfiguration newConfiguration() {
        SamlConfiguration configuration = this.configurationStore.newEntity();
        this.setDefaults(configuration);
        return configuration;
    }

    @Override
    public SamlConfiguration loadConfiguration() {
        return this.configurationStore.load();
    }

    @Override
    public SamlConfiguration create(SamlConfiguration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        this.configurationValidator.validate(configuration);
        this.configurationStore.create(configuration);
        return this.updateDeploymentManager();
    }

    @Override
    public SamlConfiguration update(SamlConfiguration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        this.configurationValidator.validate(configuration);
        this.checkExistenceForUpdate(configuration);
        this.configurationStore.update(configuration);
        return this.updateDeploymentManager();
    }

    @Nullable
    private synchronized SamlConfiguration updateDeploymentManager() {
        SamlConfiguration samlConfiguration = this.loadConfiguration();
        if (samlConfiguration == null) {
            this.log.debug("No persisted SAML Configuration found, clearing deployment.");
            this.samlDeploymentManager.clearSamlDeployment();
        } else {
            this.log.debug("Updating SamlDeploymentManager with persisted configuration", (Object)samlConfiguration);
            this.samlDeploymentManager.updateFromConfiguration(samlConfiguration);
        }
        return samlConfiguration;
    }

    @Override
    public void delete() {
        SamlConfiguration configuration = this.loadConfiguration();
        if (configuration != null) {
            this.configurationStore.delete(configuration.getId());
            this.samlDeploymentManager.clearSamlDeployment();
        }
    }

    @Override
    public boolean isConfigured() {
        return this.realmManager.isRealmEnabled("SamlRealm") && this.loadConfiguration() != null;
    }

    @Subscribe
    public void on(SamlConfigurationChangedEvent event) {
        if (event.isLocal()) {
            return;
        }
        this.log.info("Processing remote change to SAML configuration.");
        this.updateDeploymentManager();
    }

    private void checkExistenceForUpdate(SamlConfiguration configuration) {
        SamlConfiguration existingConfiguration = this.loadConfiguration();
        if (Objects.isNull(existingConfiguration)) {
            throw new SamlConfigurationException("No SAML configuration existed to update.");
        }
        if (!Objects.equals(existingConfiguration.getId(), configuration.getId())) {
            throw new SamlConfigurationException("The SAML configuration to update does not match the existing SAML configuration");
        }
    }

    private void setDefaults(SamlConfiguration configuration) {
        configuration.setEntityId(String.valueOf(BaseUrlHolder.get()) + "/service/rest" + "/v1/security/saml" + "/metadata");
        configuration.setMapping(new Mapping());
    }
}

