/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.saml.persist.entity;

import java.io.Serializable;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonatype.nexus.security.role.RoleIdentifier;
import org.sonatype.nexus.security.user.User;
import org.sonatype.nexus.security.user.UserStatus;

public interface SamlUser
extends Serializable,
Cloneable {
    public String getFirstName();

    public String getId();

    public String getLastName();

    public String getStatus();

    public String getEmail();

    public void setFirstName(String var1);

    public void setId(String var1);

    public void setLastName(String var1);

    public void setStatus(String var1);

    public void setEmail(String var1);

    public void setRoles(Set<String> var1);

    public boolean isActive();

    public Set<String> getRoles();

    default public User toUser() {
        User user = new User();
        user.setSource("SAML");
        user.setUserId(this.getId());
        user.setFirstName(this.getFirstName());
        user.setLastName(this.getLastName());
        user.setEmailAddress(this.getEmail());
        user.setStatus(UserStatus.valueOf((String)this.getStatus()));
        user.setRoles(this.getRoles().stream().map(role -> new RoleIdentifier("SAML", role)).collect(Collectors.toSet()));
        return user;
    }
}

