/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.saml.persist;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.sonatype.nexus.saml.internal.SamlMetadataTool;
import com.sonatype.nexus.saml.persist.entity.SamlConfiguration;
import java.io.IOException;
import java.io.StringReader;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import javax.validation.constraints.NotNull;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.sonatype.nexus.common.io.SafeXml;
import org.sonatype.nexus.validation.ConstraintViolationFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Named
@Singleton
public class SamlConfigurationValidator {
    private final Provider<Validator> validatorProvider;
    private final ConstraintViolationFactory constraintViolationFactory;
    private final SamlMetadataTool samlMetadataTool;

    @Inject
    public SamlConfigurationValidator(ConstraintViolationFactory constraintViolationFactory, Provider<Validator> validatorProvider, SamlMetadataTool samlMetadataTool) {
        this.constraintViolationFactory = constraintViolationFactory;
        this.validatorProvider = validatorProvider;
        this.samlMetadataTool = (SamlMetadataTool)Preconditions.checkNotNull((Object)samlMetadataTool);
    }

    @Nullable
    public void validate(@NotNull SamlConfiguration configuration) {
        Set constraintViolations = ((Validator)this.validatorProvider.get()).validate((Object)configuration, new Class[0]);
        if (!constraintViolations.isEmpty()) {
            throw new ConstraintViolationException(constraintViolations);
        }
        this.validateIdpMetadata(configuration);
    }

    private void validateIdpMetadata(SamlConfiguration configuration) {
        try {
            DocumentBuilderFactory factory = SafeXml.newdocumentBuilderFactory();
            factory.newDocumentBuilder().parse(new InputSource(new StringReader(configuration.getIdpMetadata())));
            this.samlMetadataTool.parseEntityDescriptor(configuration.getIdpMetadata());
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            throw new ConstraintViolationException((Set)Sets.newHashSet((Object[])new ConstraintViolation[]{this.createViolation("idpMetadata", "must be valid XML")}));
        }
        catch (IllegalArgumentException e) {
            throw new ConstraintViolationException((Set)Sets.newHashSet((Object[])new ConstraintViolation[]{this.createViolation("idpMetadata", e.getMessage())}));
        }
    }

    private ConstraintViolation<?> createViolation(String path, String message) {
        return this.constraintViolationFactory.createViolation(path, message);
    }
}

