/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.saml.internal.rest;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.saml.internal.rest.SamlConfigurationXO;
import com.sonatype.nexus.saml.persist.SamlConfigurationManager;
import com.sonatype.nexus.saml.persist.entity.SamlConfiguration;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.wonderland.AuthTicketService;
import org.sonatype.nexus.rest.NotCacheable;
import org.sonatype.nexus.rest.Resource;

@Named
@Singleton
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="internal/ui/saml")
public class SamlConfigurationResource
extends ComponentSupport
implements Resource {
    static final String RESOURCE_PATH = "internal/ui/saml";
    private final AuthTicketService authTicketService;
    private final SamlConfigurationManager samlConfigurationManager;

    @Inject
    public SamlConfigurationResource(AuthTicketService authTicketService, SamlConfigurationManager samlConfigurationManager) {
        this.authTicketService = authTicketService;
        this.samlConfigurationManager = (SamlConfigurationManager)Preconditions.checkNotNull((Object)samlConfigurationManager);
    }

    @GET
    @RequiresPermissions(value={"nexus:*"})
    public SamlConfigurationXO read() {
        SamlConfiguration configuration = this.samlConfigurationManager.loadConfiguration();
        if (configuration == null) {
            configuration = this.samlConfigurationManager.newConfiguration();
        }
        return SamlConfigurationXO.fromSamlConfiguration(configuration);
    }

    @PUT
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:*"})
    public void update(@NotNull @Valid SamlConfigurationXO request) {
        SamlConfiguration storedConfiguration = this.samlConfigurationManager.loadConfiguration();
        if (storedConfiguration == null) {
            SamlConfiguration newConfiguration = SamlConfigurationXO.toSamlConfiguration(request, this.samlConfigurationManager.newConfiguration());
            this.samlConfigurationManager.create(newConfiguration);
        } else {
            this.samlConfigurationManager.update(SamlConfigurationXO.toSamlConfiguration(request, storedConfiguration));
        }
    }

    @GET
    @Path(value="authToken")
    @RequiresAuthentication
    @NotCacheable
    public String authToken() {
        return this.authTicketService.createTicket();
    }
}

