/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.saml.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.saml.internal.SamlPrincipalUtil;
import com.sonatype.nexus.saml.persist.SamlConfigurationManager;
import com.sonatype.nexus.saml.persist.entity.SamlConfiguration;
import com.sonatype.nexus.saml.persist.entity.SamlUser;
import com.sonatype.nexus.saml.persist.internal.SamlUserStore;
import com.sonatype.nexus.saml.persist.internal.SamlUserUtil;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.keycloak.adapters.saml.SamlPrincipal;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.security.config.SecurityConfigurationSource;
import org.sonatype.nexus.security.user.User;
import org.sonatype.nexus.security.user.UserManager;
import org.sonatype.nexus.security.user.UserNotFoundException;
import org.sonatype.nexus.security.user.UserSearchCriteria;
import org.sonatype.nexus.security.user.UserStatus;

@Singleton
@Named(value="SAML")
public class SamlUserManager
extends ComponentSupport
implements UserManager {
    SecurityConfigurationSource securityConfigurationSource;
    private final SamlConfigurationManager samlConfigurationManager;
    private final SamlUserStore samlUserStore;

    @Inject
    public SamlUserManager(SamlConfigurationManager samlConfigurationManager, SamlUserStore samlUserStore, SecurityConfigurationSource securityConfigurationSource) {
        this.samlConfigurationManager = (SamlConfigurationManager)Preconditions.checkNotNull((Object)samlConfigurationManager);
        this.samlUserStore = (SamlUserStore)Preconditions.checkNotNull((Object)samlUserStore);
        this.securityConfigurationSource = (SecurityConfigurationSource)Preconditions.checkNotNull((Object)securityConfigurationSource);
    }

    public String getSource() {
        return "SAML";
    }

    public String getAuthenticationRealmName() {
        return "SamlRealm";
    }

    public boolean supportsWrite() {
        return false;
    }

    public Set<User> listUsers() {
        return this.samlUserStore.list().stream().map(SamlUser::toUser).collect(Collectors.toSet());
    }

    public Set<String> listUserIds() {
        return this.samlUserStore.listUserIds();
    }

    public User addUser(User user, String password) {
        SamlUser foundSamlUser = this.samlUserStore.getUser(user.getUserId());
        if (foundSamlUser != null) {
            this.log.debug("User already exists with user ID: {}. Not adding.", (Object)foundSamlUser.getId());
            return foundSamlUser.toUser();
        }
        SamlUser newSamlUser = SamlUserUtil.userToSamlUser(user, this.samlUserStore.newEntity());
        this.samlUserStore.create(newSamlUser);
        this.log.debug("Created new user with user ID {}", (Object)user.getUserId());
        return user;
    }

    public User updateUser(User user) {
        throw new UnsupportedOperationException();
    }

    public User updateUser(SamlPrincipal samlPrincipal, User user) {
        SamlConfiguration configuration = this.samlConfigurationManager.loadConfiguration();
        this.log.info("Update: {}", (Object)user.getUserId());
        SamlUser samlUser = this.samlUserStore.getUser(user.getUserId());
        this.log.info("Update--: {}", (Object)samlUser.getId());
        SamlPrincipalUtil.mapAttributes(samlPrincipal, configuration.getMapping(), samlUser);
        User updateUser = samlUser.toUser();
        updateUser.setRoles(user.getRoles());
        this.samlUserStore.update(updateUser);
        return updateUser;
    }

    public void deleteUser(String userId) throws UserNotFoundException {
        this.securityConfigurationSource.getConfiguration().removeUserRoleMapping(userId, "SAML");
        this.samlUserStore.deleteUser(userId);
    }

    public Set<User> searchUsers(UserSearchCriteria criteria) {
        return this.samlUserStore.searchUsers(criteria);
    }

    public User getUser(String userId) throws UserNotFoundException {
        SamlUser samlUser = this.samlUserStore.getUser(userId);
        if (samlUser == null) {
            throw new UserNotFoundException(userId);
        }
        return samlUser.toUser();
    }

    public User getUser(String userId, Set<String> roleIds) throws UserNotFoundException {
        return this.getUser(userId);
    }

    public void changePassword(String userId, String newPassword) {
        throw new UnsupportedOperationException("SAML users can't change passwords");
    }

    public boolean isConfigured() {
        return this.samlConfigurationManager.isConfigured();
    }

    public User addUser(SamlPrincipal samlPrincipal) {
        SamlConfiguration configuration = this.samlConfigurationManager.loadConfiguration();
        SamlUser samlUser = this.samlUserStore.newEntity();
        samlUser = SamlPrincipalUtil.toNewSamlUser(samlPrincipal, configuration.getMapping(), samlUser);
        samlUser.setStatus(UserStatus.active.name());
        samlUser.setRoles(SamlPrincipalUtil.extractGroups(samlPrincipal, configuration.getMapping()));
        this.samlUserStore.create(samlUser);
        return samlUser.toUser();
    }
}

