/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.saml.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.saml.internal.SamlAuthenticationToken;
import com.sonatype.nexus.saml.internal.SamlFeature;
import com.sonatype.nexus.saml.internal.SamlPrincipalUtil;
import com.sonatype.nexus.saml.internal.SamlUserManager;
import com.sonatype.nexus.saml.internal.SamlUserPrincipal;
import com.sonatype.nexus.saml.persist.SamlConfigurationManager;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.credential.AllowAllCredentialsMatcher;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.eclipse.sisu.Description;
import org.keycloak.adapters.saml.SamlPrincipal;
import org.slf4j.Logger;
import org.sonatype.goodies.common.Loggers;
import org.sonatype.licensing.LicensingException;
import org.sonatype.licensing.feature.Feature;
import org.sonatype.licensing.feature.LicenseFeatureVerifier;
import org.sonatype.nexus.security.role.RoleIdentifier;
import org.sonatype.nexus.security.user.User;
import org.sonatype.nexus.security.user.UserNotFoundException;

@Named(value="SamlRealm")
@Singleton
@Description(value="SAML Realm")
public class SamlRealm
extends AuthorizingRealm {
    private final Logger log = Loggers.getLogger(((Object)((Object)this)).getClass());
    private final SamlUserManager userManager;
    private final SamlConfigurationManager configurationManager;
    private final LicenseFeatureVerifier licenseVerifier;
    private final SamlFeature samlFeature;

    @Inject
    public SamlRealm(SamlUserManager userManager, SamlConfigurationManager configurationManager, LicenseFeatureVerifier licenseVerifier, SamlFeature samlFeature) {
        this.userManager = (SamlUserManager)((Object)Preconditions.checkNotNull((Object)((Object)userManager)));
        this.configurationManager = (SamlConfigurationManager)Preconditions.checkNotNull((Object)configurationManager);
        this.licenseVerifier = (LicenseFeatureVerifier)Preconditions.checkNotNull((Object)licenseVerifier);
        this.samlFeature = (SamlFeature)((Object)Preconditions.checkNotNull((Object)((Object)samlFeature)));
        this.setName("SamlRealm");
        this.setCredentialsMatcher((CredentialsMatcher)new AllowAllCredentialsMatcher());
        this.setAuthenticationTokenClass(SamlAuthenticationToken.class);
    }

    @Nullable
    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        if (this.supports(token)) {
            SamlUserPrincipal userPrincipal = this.getSamlUserPrincipal((SamlAuthenticationToken)token);
            try {
                this.licenseVerifier.verifyLicenseAndFeature((Feature)this.samlFeature);
            }
            catch (LicensingException licensingException) {
                this.log.error("Unable to login \"{}\" due to license limitation", (Object)userPrincipal);
                return null;
            }
            return new SimpleAuthenticationInfo((Object)userPrincipal.getUsername(), null, this.getName());
        }
        return null;
    }

    @Nullable
    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) throws AuthorizationException {
        if (Objects.isNull(principals)) {
            throw new AuthorizationException("Cannot authorize with no principals.");
        }
        if (principals.getRealmNames().contains(this.getName())) {
            String userId = principals.getPrimaryPrincipal().toString();
            try {
                User user = this.userManager.getUser(userId);
                return new SimpleAuthorizationInfo(user.getRoles().stream().map(RoleIdentifier::getRoleId).collect(Collectors.toSet()));
            }
            catch (UserNotFoundException e) {
                throw new AuthorizationException(String.format("User: %s could not be authorized.", userId), (Throwable)e);
            }
        }
        return null;
    }

    private SamlUserPrincipal getSamlUserPrincipal(SamlAuthenticationToken token) {
        SamlPrincipal principal = token.getSamlPrincipal();
        User user = this.requireUser(principal);
        this.log.debug("Authenticated SAML principal {} with attributes {} and friendly attributes {}", new Object[]{principal.getName(), principal.getAttributes(), SamlPrincipalUtil.extractFriendlyAttributes(principal)});
        Set<String> roles = user.getRoles().stream().map(RoleIdentifier::getRoleId).collect(Collectors.toSet());
        return new SamlUserPrincipal(user.getUserId(), this.toDisplayName(user), roles);
    }

    private User requireUser(SamlPrincipal principal) throws AuthenticationException {
        String username = this.requireUserName(principal);
        try {
            User user = this.userManager.getUser(username);
            Set roles = SamlPrincipalUtil.extractGroups(principal, this.configurationManager.loadConfiguration().getMapping()).stream().map(roleId -> new RoleIdentifier("SAML", roleId)).collect(Collectors.toSet());
            user.setRoles(roles);
            return this.userManager.updateUser(principal, user);
        }
        catch (UserNotFoundException userNotFoundException) {
            return this.userManager.addUser(principal);
        }
    }

    private String requireUserName(SamlPrincipal principal) throws AuthenticationException {
        String userName = SamlPrincipalUtil.getUserName(principal, this.configurationManager.loadConfiguration().getMapping());
        if (StringUtils.isNotBlank((CharSequence)userName)) {
            return userName;
        }
        String error = String.format("A username is required either from a %s attribute or a SAML NameID.", "username");
        this.log.error(error);
        throw new AuthenticationException(error);
    }

    private String toDisplayName(User user) {
        return String.format("%s %s", user.getFirstName(), user.getLastName());
    }
}

