/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.saml.internal;

import com.sonatype.nexus.saml.persist.entity.Mapping;
import com.sonatype.nexus.saml.persist.entity.SamlUser;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.keycloak.adapters.saml.SamlPrincipal;
import org.sonatype.nexus.security.role.RoleIdentifier;

public class SamlPrincipalUtil {
    private SamlPrincipalUtil() {
    }

    @Nullable
    public static String getUserName(SamlPrincipal principal, Mapping mapping) {
        return SamlPrincipalUtil.extractAttribute(principal, mapping.getUsernameAttributeName()).orElseGet(() -> ((SamlPrincipal)principal).getName());
    }

    public static Set<String> extractGroups(SamlPrincipal principal, Mapping mapping) {
        LinkedHashSet<String> groups = new LinkedHashSet<String>();
        Optional.ofNullable(principal.getAttributes(mapping.getGroupsAttributeName())).ifPresent(groups::addAll);
        Optional.ofNullable(principal.getFriendlyAttributes(mapping.getGroupsAttributeName())).ifPresent(groups::addAll);
        groups.removeIf(StringUtils::isBlank);
        return groups;
    }

    public static Set<RoleIdentifier> extractRoleIdentifiers(SamlPrincipal principal, Mapping mapping) {
        return SamlPrincipalUtil.extractGroups(principal, mapping).stream().map(group -> new RoleIdentifier("SAML", group)).collect(Collectors.toSet());
    }

    public static Optional<String> extractAttribute(SamlPrincipal principal, String attributeName) {
        Optional<String> attribute = Optional.ofNullable(principal.getAttribute(attributeName));
        return attribute.isPresent() ? attribute : SamlPrincipalUtil.extractFriendlyAttribute(principal, attributeName);
    }

    public static Map<String, List<String>> extractFriendlyAttributes(SamlPrincipal principal) {
        return principal.getFriendlyNames().stream().collect(Collectors.toMap(name -> name, arg_0 -> ((SamlPrincipal)principal).getFriendlyAttributes(arg_0)));
    }

    public static SamlUser toNewSamlUser(SamlPrincipal samlPrincipal, Mapping mapping, SamlUser samlUser) {
        samlUser.setId(SamlPrincipalUtil.getUserName(samlPrincipal, mapping));
        SamlPrincipalUtil.mapAttributes(samlPrincipal, mapping, samlUser);
        return samlUser;
    }

    public static void mapAttributes(SamlPrincipal samlPrincipal, Mapping mapping, SamlUser samlUser) {
        SamlPrincipalUtil.mapAttribute(samlPrincipal, mapping::getEmailAttributeName, samlUser::setEmail);
        SamlPrincipalUtil.mapAttribute(samlPrincipal, mapping::getFirstNameAttributeName, samlUser::setFirstName);
        SamlPrincipalUtil.mapAttribute(samlPrincipal, mapping::getLastNameAttributeName, samlUser::setLastName);
    }

    private static void mapAttribute(SamlPrincipal samlPrincipal, Supplier<String> attributeNameSupplier, Consumer<String> attributeValueConsumer) {
        Optional.ofNullable(attributeNameSupplier.get()).ifPresent(attributeName -> SamlPrincipalUtil.extractAttribute(samlPrincipal, attributeName).ifPresent(attributeValueConsumer));
    }

    private static Optional<String> extractFriendlyAttribute(SamlPrincipal samlPrincipal, String attributeName) {
        return Optional.ofNullable(samlPrincipal.getFriendlyAttribute(attributeName));
    }
}

