/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.saml.internal;

import com.google.inject.Module;
import com.google.inject.servlet.ServletModule;
import com.sonatype.nexus.saml.internal.JwtSamlFilter;
import com.sonatype.nexus.saml.internal.SamlLogoutFilter;
import com.sonatype.nexus.saml.internal.SamlModule;
import javax.inject.Named;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.security.FilterChainModule;
import org.sonatype.nexus.security.FilterProviderSupport;
import org.sonatype.nexus.security.JwtSecurityFilter;

@Named
@FeatureFlag(name="nexus.jwt.enabled")
public class JwtSamlModule
extends SamlModule {
    @Override
    protected void bindSamlFilter() {
        this.bind(FilterProviderSupport.filterKey((String)"nx-saml-auth")).to(JwtSamlFilter.class);
    }

    @Override
    protected ServletModule configureServletModule() {
        return new ServletModule(){

            protected void configureServlets() {
                this.filter("/saml", new String[0]).through(JwtSecurityFilter.class);
                this.filter("/saml", new String[0]).through(JwtSamlFilter.class);
                this.filter("/service/rapture/session", new String[0]).through(SamlLogoutFilter.class);
            }
        };
    }

    @Override
    protected Module configureFilterChainModule() {
        return new FilterChainModule(){

            protected void configure() {
                this.addFilterChain("/saml", new String[]{"nx-jwt", "nx-saml-auth"});
            }
        };
    }
}

