/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.saml.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.saml.internal.SamlAuthenticatorForSamlEndpoint;
import javax.servlet.http.Cookie;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.keycloak.adapters.saml.SamlDeployment;
import org.keycloak.adapters.saml.SamlSessionStore;
import org.keycloak.adapters.spi.AuthOutcome;
import org.keycloak.adapters.spi.HttpFacade;
import org.sonatype.nexus.security.JwtHelper;

public class JwtSamlAuthenticatorForSamlEndpoint
extends SamlAuthenticatorForSamlEndpoint {
    private final HttpFacade httpFacade;
    private final JwtHelper jwtHelper;

    public JwtSamlAuthenticatorForSamlEndpoint(HttpFacade httpFacade, SamlDeployment samlDeployment, SamlSessionStore samlSessionStore, JwtHelper jwtHelper) {
        super(httpFacade, samlDeployment, samlSessionStore);
        this.httpFacade = (HttpFacade)Preconditions.checkNotNull((Object)httpFacade);
        this.jwtHelper = (JwtHelper)Preconditions.checkNotNull((Object)jwtHelper);
    }

    public AuthOutcome authenticate() {
        Subject subject;
        AuthOutcome outcome = super.authenticate();
        if (AuthOutcome.AUTHENTICATED.equals((Object)outcome) && (subject = SecurityUtils.getSubject()).isAuthenticated()) {
            Cookie cookie = this.jwtHelper.createJwtCookie(subject, this.httpFacade.getRequest().isSecure());
            this.httpFacade.getResponse().setCookie(cookie.getName(), cookie.getValue(), cookie.getPath(), cookie.getDomain(), cookie.getMaxAge(), cookie.getSecure(), cookie.isHttpOnly());
        }
        return outcome;
    }
}

