/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.saml.events;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.saml.events.SamlConfigurationChangedEvent;
import com.sonatype.nexus.saml.events.SamlConfigurationDTO;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.audit.AuditData;
import org.sonatype.nexus.audit.AuditorSupport;
import org.sonatype.nexus.common.event.EventAware;

@Named
@Singleton
public class SamlAuditor
extends AuditorSupport
implements EventAware {
    public static final String DOMAIN = "SamlRealm";

    public SamlAuditor() {
        this.registerType(SamlConfigurationChangedEvent.class, "configChanged");
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(SamlConfigurationChangedEvent event) {
        SamlConfigurationDTO samlConfiguration = event.getSamlConfiguration();
        if (this.isRecording() && samlConfiguration != null) {
            AuditData data = new AuditData();
            data.setDomain(DOMAIN);
            data.setType(this.type(((Object)((Object)event)).getClass()));
            Map attributes = data.getAttributes();
            attributes.put("User name", samlConfiguration.getUsernameAttributeName());
            attributes.put("First name", samlConfiguration.getFirstNameAttributeName());
            attributes.put("Last name", samlConfiguration.getLastNameAttributeName());
            attributes.put("Email", samlConfiguration.getEmailAttributeName());
            attributes.put("Roles/Groups", samlConfiguration.getGroupsAttributeName());
            this.record(data);
        }
    }
}

