/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.saml.api;

import com.sonatype.nexus.saml.api.model.SamlConfigurationXO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.core.Response;

@Api(value="Security management: SAML")
public interface SamlApiResourceDoc {
    @ApiOperation(value="Get SAML configuration")
    @ApiResponses(value={@ApiResponse(code=200, message="SAML configuration returned"), @ApiResponse(code=401, message="Authentication required"), @ApiResponse(code=403, message="Insufficient permissions"), @ApiResponse(code=404, message="SAML configuration not found")})
    public SamlConfigurationXO getSamlConfiguration();

    @ApiOperation(value="Create or update SAML configuration")
    @ApiResponses(value={@ApiResponse(code=201, message="SAML configuration created"), @ApiResponse(code=204, message="SAML configuration updated"), @ApiResponse(code=401, message="Authentication required"), @ApiResponse(code=403, message="Insufficient permissions"), @ApiResponse(code=404, message="SAML configuration not found")})
    public Response putSamlConfiguration(@NotNull @Valid SamlConfigurationXO var1);

    @ApiOperation(value="Delete SAML configuration")
    @ApiResponses(value={@ApiResponse(code=204, message="SAML configuration deleted"), @ApiResponse(code=401, message="Authentication required"), @ApiResponse(code=403, message="Insufficient permissions")})
    public Response deleteSamlConfiguration();

    @ApiOperation(value="Get service provider metadata XML document")
    @ApiResponses(value={@ApiResponse(code=200, message="Metadata Returned"), @ApiResponse(code=401, message="Authentication required"), @ApiResponse(code=404, message="Metadata not found"), @ApiResponse(code=403, message="Insufficient permissions")})
    public Response getMetadata();

    @ApiOperation(value="Get service provider signing certificate in PEM format")
    @ApiResponses(value={@ApiResponse(code=200, message="PEM file Returned"), @ApiResponse(code=401, message="Authentication required"), @ApiResponse(code=404, message="PEM file not found"), @ApiResponse(code=403, message="Insufficient permissions")})
    public Response getPublicCertificateInPemFormat();
}

