/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.saml.api;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.saml.api.SamlApiResourceDoc;
import com.sonatype.nexus.saml.api.model.SamlConfigurationXO;
import com.sonatype.nexus.saml.internal.SamlDeploymentManager;
import com.sonatype.nexus.saml.persist.SamlConfigurationManager;
import com.sonatype.nexus.saml.persist.entity.SamlConfiguration;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.rest.Resource;
import org.sonatype.nexus.rest.WebApplicationMessageException;

@Named
@Singleton
@Path(value="/v1/security/saml")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class SamlApiResource
extends ComponentSupport
implements Resource,
SamlApiResourceDoc {
    public static final String RESOURCE_URI = "/v1/security/saml";
    private static final String METADATA = "metadata";
    private static final String PEM = "pem";
    private static final String NOT_FOUND_MESSAGE = "SAML configuration was not found";
    public static final String APPLICATION_X_PEM_FILE = "application/x-pem-file";
    private final SamlConfigurationManager configurationManager;
    private final SamlDeploymentManager samlDeploymentManager;

    @Inject
    public SamlApiResource(SamlConfigurationManager configurationManager, SamlDeploymentManager samlDeploymentManager) {
        this.configurationManager = (SamlConfigurationManager)Preconditions.checkNotNull((Object)configurationManager);
        this.samlDeploymentManager = (SamlDeploymentManager)((Object)Preconditions.checkNotNull((Object)((Object)samlDeploymentManager)));
    }

    @Override
    @GET
    @RequiresPermissions(value={"nexus:*"})
    public SamlConfigurationXO getSamlConfiguration() {
        return SamlConfigurationXO.toSamlConfigurationXO(this.loadConfiguration());
    }

    @Override
    @PUT
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:*"})
    public Response putSamlConfiguration(@NotNull @Valid SamlConfigurationXO configurationXO) {
        try {
            SamlConfiguration configuration = this.configurationManager.loadConfiguration();
            if (Objects.isNull(configuration)) {
                this.configurationManager.create(SamlConfigurationXO.toSamlConfiguration(configurationXO, this.configurationManager.newConfiguration()));
                return Response.status((Response.Status)Response.Status.CREATED).build();
            }
            this.configurationManager.update(SamlConfigurationXO.toSamlConfiguration(configurationXO, configuration));
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        catch (Exception e) {
            this.log.debug("Unable to create or update SAML configuration", (Throwable)e);
            throw new WebApplicationMessageException(Response.Status.BAD_REQUEST, (Object)("\"" + e.getMessage() + "\""), "application/json");
        }
    }

    @Override
    @DELETE
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:*"})
    public Response deleteSamlConfiguration() {
        this.configurationManager.delete();
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    private SamlConfiguration loadConfiguration() {
        SamlConfiguration configuration = this.configurationManager.loadConfiguration();
        if (Objects.isNull(configuration)) {
            throw new WebApplicationMessageException(Response.Status.NOT_FOUND, (Object)"\"SAML configuration was not found\"", "application/json");
        }
        return configuration;
    }

    @Override
    @GET
    @Path(value="metadata")
    @Produces(value={"application/xml"})
    @RequiresAuthentication
    public Response getMetadata() {
        return this.samlDeploymentManager.getMetadata().map(xml -> Response.status((Response.Status)Response.Status.OK).entity(xml)).orElseGet(() -> Response.status((Response.Status)Response.Status.NOT_FOUND)).build();
    }

    @Override
    @GET
    @Path(value="pem")
    @Produces(value={"application/x-pem-file"})
    @RequiresAuthentication
    public Response getPublicCertificateInPemFormat() {
        return this.samlDeploymentManager.getPublicCertificateInPemFormat().map(pem -> Response.status((Response.Status)Response.Status.OK).entity(pem)).orElseGet(() -> Response.status((Response.Status)Response.Status.NOT_FOUND)).build();
    }
}

