/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.upgrade;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.upgrade.DependsOn;
import org.sonatype.nexus.common.upgrade.Upgrades;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.DatabaseUpgradeSupport;

@Named
@Singleton
@Upgrades(model="nuget", from="1.0", to="1.1")
@DependsOn(model="config", version="1.8", checkpoint=true)
public class NugetUpgrade_1_1
extends DatabaseUpgradeSupport {
    private static final String UPDATE_NUGET_PROXY_PROPERTY = "UPDATE repository SET attributes.nugetProxy = {} WHERE recipe_name = 'nuget-proxy' AND attributes.nugetProxy IS NULL";
    private static final String UPDATE_V2_REPOSITORIES = "UPDATE repository SET attributes.nugetProxy.nugetVersion = 'V2' WHERE recipe_name = 'nuget-proxy' AND NOT (attributes.proxy.remoteUrl LIKE '%.json')";
    private static final String UPDATE_V3_REPOSITORIES = "UPDATE repository SET attributes.nugetProxy.nugetVersion = 'V3' WHERE recipe_name = 'nuget-proxy' AND attributes.proxy.remoteUrl LIKE '%.json'";
    private final Provider<DatabaseInstance> configDatabaseInstance;

    @Inject
    public NugetUpgrade_1_1(@Named(value="config") @Named(value="config") Provider<DatabaseInstance> configDatabaseInstance) {
        this.configDatabaseInstance = (Provider)Preconditions.checkNotNull(configDatabaseInstance);
    }

    public void apply() {
        if (NugetUpgrade_1_1.hasSchemaClass(this.configDatabaseInstance, (String)"repository")) {
            this.updateNugetProxyVersion();
        }
    }

    private void updateNugetProxyVersion() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.configDatabaseInstance.get()).connect();){
            Integer updatedRepositoryCount = (Integer)db.command((OCommandRequest)new OCommandSQL(UPDATE_NUGET_PROXY_PROPERTY)).execute(new Object[0]);
            this.log.info("Updated NuGet proxy properties in {} repositories", (Object)updatedRepositoryCount);
            Integer updatedV2Count = (Integer)db.command((OCommandRequest)new OCommandSQL(UPDATE_V2_REPOSITORIES)).execute(new Object[0]);
            this.log.info("Updated {} V2 NuGet proxy repositories", (Object)updatedV2Count);
            Integer updatedV3Count = (Integer)db.command((OCommandRequest)new OCommandSQL(UPDATE_V3_REPOSITORIES)).execute(new Object[0]);
            this.log.info("Updated {} V3 NuGet proxy repositories", (Object)updatedV3Count);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

