/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.orient.internal.v3.packagemetadata;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.sonatype.nexus.repository.nuget.internal.v3.NugetV3ProxyUtil;
import com.sonatype.nexus.repository.nuget.orient.internal.OrientNugetAssetUtils;
import com.sonatype.nexus.repository.nuget.v3.models.RegistrationIndex;
import com.sonatype.nexus.repository.nuget.v3.models.RegistrationLeaf;
import com.sonatype.nexus.repository.nuget.v3.models.RegistrationPage;
import com.sonatype.nexus.repository.nuget.v3.models.ServiceIndex;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalTouchBlob;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.StringPayload;
import org.sonatype.nexus.transaction.UnitOfWork;

@Facet.Exposed
public class OrientPackageMetadataFacet
extends FacetSupport {
    private final ObjectMapper objectMapper;

    @Inject
    public OrientPackageMetadataFacet(ObjectMapper objectMapper) {
        this.objectMapper = Objects.requireNonNull(objectMapper);
    }

    @TransactionalTouchBlob
    @Nullable
    public Content getRegistrationIndex(String path, ServiceIndex serviceIndex, boolean returnsOriginal) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = OrientNugetAssetUtils.findAssetWithName(tx, path, this.getRepository());
        if (asset == null) {
            return null;
        }
        RegistrationIndex index = OrientNugetAssetUtils.readContent(this.objectMapper, () -> ((Blob)tx.requireBlob(asset.requireBlobRef())).getInputStream(), RegistrationIndex.class);
        if (!returnsOriginal) {
            this.rewriteRegistrationIndexUrls(index, String.valueOf(this.getRepository().getUrl()) + asset.name(), serviceIndex);
        }
        StringPayload content = new StringPayload(this.objectMapper.writeValueAsString((Object)index), "application/json");
        return OrientNugetAssetUtils.toContent(asset, (Payload)content);
    }

    public void rewriteRegistrationIndexUrls(RegistrationIndex registrationIndex, String registrationIndexUrl, ServiceIndex serviceIndex) {
        registrationIndex.getPages().forEach(p -> this.rewriteRegistrationPageUrls((RegistrationPage)p, registrationIndexUrl, serviceIndex));
    }

    public void rewriteRegistrationPageUrls(RegistrationPage page, String registrationIndexUrl, ServiceIndex serviceIndex) {
        page.setParent(registrationIndexUrl);
        if (page.getId() != null) {
            page.setId(this.rewritePageId(page.getId(), serviceIndex));
        }
        page.getLeaves().forEach(l -> NugetV3ProxyUtil.rewritePageLeafUrls(this.getRepository().getUrl(), l, serviceIndex));
    }

    public void rewriteRegistrationLeafUrls(RegistrationLeaf leaf, ServiceIndex serviceIndex) {
        leaf.setId(NugetV3ProxyUtil.buildProxyUrl(leaf.getId(), serviceIndex));
        if (StringUtils.isNotBlank((CharSequence)leaf.getPackageContent())) {
            leaf.setPackageContent(NugetV3ProxyUtil.buildProxyUrl(leaf.getPackageContent(), serviceIndex));
        }
        if (StringUtils.isNotBlank((CharSequence)leaf.getRegistration())) {
            leaf.setRegistration(NugetV3ProxyUtil.buildProxyUrl(leaf.getRegistration(), serviceIndex));
        }
    }

    @VisibleForTesting
    protected String rewritePageId(String remotePageId, ServiceIndex serviceIndex) {
        return NugetV3ProxyUtil.rewritePageId(remotePageId, serviceIndex);
    }
}

