/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.orient.internal.v3;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.sonatype.nexus.repository.nuget.internal.NugetProxy;
import com.sonatype.nexus.repository.nuget.internal.v3.NugetV3ProxyPackageContentFacet;
import com.sonatype.nexus.repository.nuget.internal.v3.NugetV3ProxyRepositorySignaturesFacet;
import com.sonatype.nexus.repository.nuget.internal.v3.NugetV3ProxyUtil;
import com.sonatype.nexus.repository.nuget.internal.v3.routing.NugetContentMatcher;
import com.sonatype.nexus.repository.nuget.internal.v3.routing.NugetMetadataMatcher;
import com.sonatype.nexus.repository.nuget.orient.internal.OrientNugetAssetUtils;
import com.sonatype.nexus.repository.nuget.orient.internal.OrientNugetProxyFacet;
import com.sonatype.nexus.repository.nuget.orient.internal.v3.OrientNugetV3FacetSupport;
import com.sonatype.nexus.repository.nuget.orient.internal.v3.packagemetadata.OrientPackageMetadataFacet;
import com.sonatype.nexus.repository.nuget.v3.AssetKind;
import com.sonatype.nexus.repository.nuget.v3.NugetV3ServiceIndexFacet;
import com.sonatype.nexus.repository.nuget.v3.models.Certificate;
import com.sonatype.nexus.repository.nuget.v3.models.RegistrationIndex;
import com.sonatype.nexus.repository.nuget.v3.models.RegistrationLeaf;
import com.sonatype.nexus.repository.nuget.v3.models.RegistrationPage;
import com.sonatype.nexus.repository.nuget.v3.models.RepositorySignaturesIndex;
import com.sonatype.nexus.repository.nuget.v3.models.ServiceIndex;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.joda.time.DateTime;
import org.joda.time.base.BaseDateTime;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.common.app.BaseUrlHolder;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.cache.CacheInfo;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.proxy.ProxyFacet;
import org.sonatype.nexus.repository.proxy.ProxyRepositoryConfiguration;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalDeleteBlob;
import org.sonatype.nexus.repository.transaction.TransactionalTouchBlob;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.payloads.StringPayload;
import org.sonatype.nexus.scheduling.PeriodicJobService;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
@Facet.Exposed
public class OrientNugetV3ProxyFacetImpl
extends OrientNugetV3FacetSupport
implements NugetV3ServiceIndexFacet,
NugetProxy {
    private final ObjectMapper objectMapper;
    private final PeriodicJobService periodicJobService;
    private Optional<PeriodicJobService.PeriodicJob> periodicJob = Optional.empty();

    @Inject
    public OrientNugetV3ProxyFacetImpl(ObjectMapper objectMapper, PeriodicJobService periodicJobService) {
        this.objectMapper = Objects.requireNonNull(objectMapper);
        this.periodicJobService = Objects.requireNonNull(periodicJobService);
    }

    protected void doStart() throws Exception {
        this.periodicJobService.startUsing();
    }

    protected void doStop() throws Exception {
        this.periodicJob.ifPresent(PeriodicJobService.PeriodicJob::cancel);
        this.periodicJobService.stopUsing();
    }

    protected void doConfigure(Configuration configuration) throws Exception {
        this.periodicJobService.runOnce(() -> {
            Content content = (Content)BaseUrlHolder.with((String)"http://localhost", (String)"/", this::maybeRefreshServiceIndex);
            if (content != null) {
                this.scheduleServiceIndexRefresh(content);
            }
        }, 60);
    }

    @VisibleForTesting
    static Optional<Duration> computeDelay(@Nullable Content content, Duration metadataMaxAge) {
        return Optional.ofNullable(content).map(Content::getAttributes).map(attr -> (CacheInfo)attr.get(CacheInfo.class)).map(CacheInfo::getLastVerified).map(lastVerified -> lastVerified.plus(metadataMaxAge.toMillis())).map(BaseDateTime::getMillis).map(nextVerification -> nextVerification - DateTime.now().getMillis()).filter(delayMs -> delayMs > 0L).map(Duration::ofMillis).map(dly -> dly.plusSeconds(1L));
    }

    private Content maybeRefreshServiceIndex() {
        Content content = (Content)Transactional.operation.withDb(((StorageFacet)this.getRepository().facet(StorageFacet.class)).txSupplier()).call(() -> {
            try {
                Context serviceIndexRequestContext = this.createServiceIndexRequestContext();
                return ((ProxyFacet)this.facet(ProxyFacet.class)).get(serviceIndexRequestContext);
            }
            catch (Exception exception) {
                this.log.warn("Failed to refresh service index on {}", (Object)this.getRepository().getName());
                return null;
            }
        });
        return content;
    }

    private void scheduleServiceIndexRefresh(Content content) {
        if (this.periodicJob.isPresent() || content == null) {
            return;
        }
        ProxyRepositoryConfiguration proxyConfiguration = ((ProxyFacet)this.getRepository().facet(ProxyFacet.class)).getConfiguration();
        OrientNugetV3ProxyFacetImpl.computeDelay(content, proxyConfiguration.getMetadataMaxAge()).ifPresent(refreshDelay -> {
            Duration refreshInterval = proxyConfiguration.getMetadataMaxAge().plusSeconds(1L);
            if (refreshInterval.compareTo(Duration.ofHours(1L)) < 0) {
                refreshInterval = Duration.ofHours(1L);
            }
            this.log.debug("Scheduling service reload in {} with interval {}", refreshDelay, (Object)refreshInterval);
            Runnable job = () -> {
                Object object = BaseUrlHolder.with((String)"http://localhost", (String)"/", this::maybeRefreshServiceIndex);
            };
            this.periodicJob = Optional.of(this.periodicJobService.schedule(job, refreshDelay, refreshInterval));
        });
    }

    @Override
    public ServiceIndex getServiceIndex() throws IOException {
        Content serviceIndexContent = Optional.ofNullable(this.getServiceIndexContent()).orElseGet(this::maybeRefreshServiceIndex);
        if (serviceIndexContent == null) {
            throw new IOException("Service Index Unavailable");
        }
        Throwable throwable = null;
        Object var4_4 = null;
        try (InputStream in = serviceIndexContent.openInputStream();){
            return (ServiceIndex)this.objectMapper.readValue(in, ServiceIndex.class);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Context createServiceIndexRequestContext() {
        Context serviceIndexRequestContext = new Context(this.getRepository(), new Request.Builder().action("GET").path("/index.json").build());
        serviceIndexRequestContext.getAttributes().set(AssetKind.class, (Object)AssetKind.SERVICE_INDEX);
        return serviceIndexRequestContext;
    }

    @Override
    public void removeServiceIndex() {
        UnitOfWork.begin((Supplier)((StorageFacet)this.getRepository().facet(StorageFacet.class)).txSupplier());
        try {
            this.deleteServiceIndex();
        }
        finally {
            UnitOfWork.end();
        }
    }

    @Override
    public String getUrl(Context context) {
        try {
            switch ((AssetKind)((Object)context.getAttributes().require(AssetKind.class))) {
                case SERVICE_INDEX: {
                    return ((ProxyFacet)this.getRepository().facet(ProxyFacet.class)).getRemoteUrl().toString();
                }
                case REGISTRATION_INDEX: {
                    return NugetV3ProxyUtil.buildRemoteUri(context, NugetV3ProxyUtil.joinPath(NugetMetadataMatcher.getMetadataPackageId(context), "index.json")).toString();
                }
                case REGISTRATION_PAGE: 
                case REGISTRATION_LEAF: {
                    return NugetV3ProxyUtil.buildRemoteUri(context, NugetMetadataMatcher.getMetadataPath(context)).toString();
                }
                case VERSIONS: {
                    return NugetV3ProxyUtil.buildRemoteUri(context, NugetV3ProxyUtil.joinPath(NugetContentMatcher.getContentPackageId(context), "index.json")).toString();
                }
                case MANIFEST: {
                    String id = NugetContentMatcher.getContentPackageId(context);
                    String version = NugetContentMatcher.getContentVersion(context);
                    return NugetV3ProxyUtil.buildRemoteUri(context, NugetV3ProxyUtil.joinPath(id, version, String.valueOf(id) + ".nuspec")).toString();
                }
                case CONTENT: {
                    String id = NugetContentMatcher.getContentPackageId(context);
                    String version = NugetContentMatcher.getContentVersion(context);
                    Optional<URI> uri = NugetV3ProxyUtil.buildRemoteUriOptional(context, NugetV3ProxyUtil.joinPath(id, version, String.valueOf(id) + "." + version + ".nupkg"));
                    if (uri.isPresent()) {
                        return uri.get().toString();
                    }
                    return ((NugetV3ProxyPackageContentFacet)this.facet(NugetV3ProxyPackageContentFacet.class)).lookForPackageContentUrlInMetadataFiles(id, version).orElse(null);
                }
                case REPOSITORY_SIGNATURES: {
                    return NugetV3ProxyUtil.buildRemoteUri(context).toString();
                }
                case REPOSITORY_SIGNATURES_CERTIFICATES: {
                    return this.getCertificateUrl(context);
                }
            }
            throw new RuntimeException("Unsupported type: " + ((AssetKind)((Object)context.getAttributes().require(AssetKind.class))).name());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to build remote URL for request: " + context.getRequest(), e);
        }
    }

    private String getCertificateUrl(Context context) {
        RepositorySignaturesIndex repositorySignaturesIndex = (RepositorySignaturesIndex)context.getAttributes().get(RepositorySignaturesIndex.class);
        if (repositorySignaturesIndex != null) {
            NugetV3ProxyRepositorySignaturesFacet facet = (NugetV3ProxyRepositorySignaturesFacet)context.getRepository().facet(NugetV3ProxyRepositorySignaturesFacet.class);
            String certificateFingerprint = NugetMetadataMatcher.getCertificateFingerprint(context);
            return facet.getRepositorySignaturesCertificate(repositorySignaturesIndex, certificateFingerprint).map(Certificate::getContentUrl).orElse(null);
        }
        return null;
    }

    @Override
    public Content fetch(Context context, Content stale) throws IOException {
        return ((OrientNugetProxyFacet)context.getRepository().facet(OrientNugetProxyFacet.class)).fetch(this.getUrl(context), context, stale);
    }

    @Override
    protected Content storeServiceIndex(Content content) throws IOException {
        ServiceIndex serviceIndex = OrientNugetAssetUtils.readContent(this.objectMapper, () -> ((Content)content).openInputStream(), ServiceIndex.class);
        ServiceIndex upstreamServiceIndex = NugetV3ProxyUtil.toUpstreamServiceIndex(serviceIndex);
        String upstreamServiceIndexJson = this.objectMapper.writeValueAsString((Object)upstreamServiceIndex);
        Content upstreamContent = this.changePayload(content, upstreamServiceIndexJson);
        OrientNugetAssetUtils.storeContent(this.getRepository(), upstreamContent, "index.json");
        ServiceIndex nxrmUpstreamServiceIndex = NugetV3ProxyUtil.buildNxrmServiceIndex(upstreamServiceIndex, this.getRepository().getUrl());
        String nxrmUpstreamServiceIndexJson = this.objectMapper.writeValueAsString((Object)nxrmUpstreamServiceIndex);
        return this.changePayload(content, nxrmUpstreamServiceIndexJson);
    }

    @Override
    protected Content rewriteRegistrationContent(AssetKind assetKind, String name, Content content) throws IOException {
        switch (assetKind) {
            case REGISTRATION_INDEX: {
                RegistrationIndex registrationIndex = OrientNugetAssetUtils.readContent(this.objectMapper, () -> ((Content)content).openInputStream(), RegistrationIndex.class);
                ((OrientPackageMetadataFacet)this.facet(OrientPackageMetadataFacet.class)).rewriteRegistrationIndexUrls(registrationIndex, NugetV3ProxyUtil.joinPath(this.getRepository().getUrl(), name), this.getServiceIndex());
                return this.changePayload(content, this.objectMapper.writeValueAsString((Object)registrationIndex));
            }
            case REGISTRATION_PAGE: {
                RegistrationPage registrationPage = OrientNugetAssetUtils.readContent(this.objectMapper, () -> ((Content)content).openInputStream(), RegistrationPage.class);
                ((OrientPackageMetadataFacet)this.facet(OrientPackageMetadataFacet.class)).rewriteRegistrationPageUrls(registrationPage, NugetV3ProxyUtil.buildProxyUrl(registrationPage.getParent(), this.getServiceIndex()), this.getServiceIndex());
                return this.changePayload(content, this.objectMapper.writeValueAsString((Object)registrationPage));
            }
            case REGISTRATION_LEAF: {
                RegistrationLeaf pageLeaf = OrientNugetAssetUtils.readContent(this.objectMapper, () -> ((Content)content).openInputStream(), RegistrationLeaf.class);
                ((OrientPackageMetadataFacet)this.facet(OrientPackageMetadataFacet.class)).rewriteRegistrationLeafUrls(pageLeaf, this.getServiceIndex());
                return this.changePayload(content, this.objectMapper.writeValueAsString((Object)pageLeaf));
            }
        }
        throw new RuntimeException("Unexpected asset kind: " + assetKind.name());
    }

    private Content changePayload(Content fromContent, String newPayload) {
        Content content = new Content((Payload)new StringPayload(newPayload, fromContent.getContentType()));
        fromContent.getAttributes().entries().forEach(e -> {
            Object object = content.getAttributes().set((String)e.getKey(), e.getValue());
        });
        return content;
    }

    @Override
    @Nullable
    @TransactionalTouchBlob
    protected Content getServiceIndexContent() throws IOException {
        Asset asset = this.findAsset("index.json");
        if (asset == null) {
            return null;
        }
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Blob blob = tx.getBlob(asset.blobRef());
        if (blob == null) {
            return null;
        }
        ServiceIndex serviceIndex = OrientNugetAssetUtils.readContent(this.objectMapper, () -> ((Blob)blob).getInputStream(), ServiceIndex.class);
        serviceIndex = NugetV3ProxyUtil.buildNxrmServiceIndex(serviceIndex, this.getRepository().getUrl());
        return OrientNugetAssetUtils.toContent(asset, (Payload)new StringPayload(this.objectMapper.writeValueAsString((Object)serviceIndex), asset.contentType()));
    }

    @TransactionalDeleteBlob
    protected void deleteServiceIndex() {
        this.deleteAsset("index.json");
    }
}

