/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.orient.internal.v3;

import com.sonatype.nexus.repository.nuget.internal.NugetDataUtils;
import com.sonatype.nexus.repository.nuget.internal.v3.NugetV3HostedFacet;
import com.sonatype.nexus.repository.nuget.internal.v3.NugetV3SemVerComparator;
import com.sonatype.nexus.repository.nuget.orient.OrientNugetComponentHelper;
import com.sonatype.nexus.repository.nuget.orient.internal.OrientNugetAssetUtils;
import com.sonatype.nexus.repository.nuget.orient.internal.v3.OrientNugetV3FacetSupport;
import com.sonatype.nexus.repository.nuget.v3.AssetKind;
import com.sonatype.nexus.repository.nuget.v3.models.AvailableVersions;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

public class OrientNugetV3HostedFacet
extends OrientNugetV3FacetSupport
implements NugetV3HostedFacet {
    @Override
    protected Content rewriteRegistrationContent(AssetKind assetKind, String name, Content content) {
        return content;
    }

    @Override
    protected Content getServiceIndexContent() throws IOException {
        throw new UnsupportedOperationException("Hosted generates service index on the fly");
    }

    @Override
    protected Content storeServiceIndex(Content content) throws IOException {
        throw new UnsupportedOperationException("Hosted generates service index on the fly");
    }

    @Override
    @Transactional
    public AvailableVersions getPackageVersions(String packageId) {
        Iterable<Component> components = OrientNugetComponentHelper.findComponents((StorageTx)UnitOfWork.currentTx(), packageId, Collections.singletonList(this.getRepository()));
        List<String> versions = StreamSupport.stream(components.spliterator(), false).map(Component::version).sorted(NugetV3SemVerComparator.INSTANCE).collect(Collectors.toList());
        AvailableVersions availableVersions = new AvailableVersions();
        availableVersions.setVersions(versions);
        return availableVersions;
    }

    @Override
    @Transactional
    public Optional<Content> getAssetContent(String packageId, String version) {
        Component component = OrientNugetComponentHelper.findComponent((StorageTx)UnitOfWork.currentTx(), packageId, version, Collections.singletonList(this.getRepository()));
        if (component == null) {
            component = this.findByNormalizedVersion((StorageTx)UnitOfWork.currentTx(), packageId, version);
        }
        if (component == null) {
            return Optional.empty();
        }
        Asset asset = ((StorageTx)UnitOfWork.currentTx()).firstAsset(component);
        if (asset == null || asset.blobRef() == null) {
            return Optional.empty();
        }
        return Optional.of(OrientNugetAssetUtils.toContent(asset, ((StorageTx)UnitOfWork.currentTx()).requireBlob(asset.requireBlobRef())));
    }

    @Nullable
    protected Component findByNormalizedVersion(StorageTx tx, String packageId, String version) {
        Iterable<Component> components = OrientNugetComponentHelper.findComponents(tx, packageId, Collections.singletonList(this.getRepository()));
        if (components != null && components.iterator().hasNext()) {
            return StreamSupport.stream(components.spliterator(), false).filter(c -> {
                String componentVersion = c.version();
                String componentNormalizedVersion = NugetDataUtils.buildNormalizeVersion(componentVersion).orElse(null);
                return version.equalsIgnoreCase(componentNormalizedVersion);
            }).findFirst().orElse(null);
        }
        return null;
    }
}

