/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.orient.internal.v2;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.collections4.map.CaseInsensitiveMap;
import org.codehaus.plexus.util.StringUtils;
import org.odata4j.expression.BoolCommonExpression;
import org.odata4j.expression.BoolParenExpression;
import org.odata4j.expression.CommonExpression;
import org.odata4j.expression.EntitySimpleProperty;
import org.odata4j.expression.EqExpression;
import org.odata4j.expression.OrExpression;
import org.odata4j.expression.OrderByExpression;
import org.odata4j.expression.ParenExpression;
import org.odata4j.expression.StringLiteral;
import org.odata4j.expression.ToLowerMethodCallExpression;
import org.odata4j.producer.QueryInfo;
import org.odata4j.producer.jpa.JPASkipToken;
import org.odata4j.producer.jpa.JPQLGenerator;
import org.odata4j.producer.resources.OptionsQueryParser;
import org.sonatype.nexus.repository.storage.Query;

public class OrientODataUtils {
    public static final ImmutableMap<String, String> COLUMN_ALIASES = OrientODataUtils.columnAliases();

    public static Query query(Map<String, String> originalQuery, boolean count) {
        return OrientODataUtils.query(originalQuery, Collections.emptyList(), count);
    }

    public static Query query(Map<String, String> originalQuery, List<String> groupBy, boolean count) {
        Map<String, String> query = OrientODataUtils.applyQueryDefaults(originalQuery);
        Query.Builder q = Query.builder();
        boolean hasTerms = false;
        String[] stringArray = OrientODataUtils.getSanitizedValue(query, "searchTerm").split("[+\\s]+");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String term = stringArray[n2];
            if (StringUtils.isNotBlank((String)term)) {
                term = String.valueOf('%') + term + '%';
                if (!hasTerms) {
                    q.where("(");
                    hasTerms = true;
                } else {
                    q.where(" OR ");
                }
                q.where(String.valueOf(OrientODataUtils.nugat("keywords")) + " LIKE ").param((Object)term.toLowerCase());
            }
            ++n2;
        }
        if (hasTerms) {
            q.where(")");
        }
        String id = StringUtils.strip((String)query.get("id"), (String)"\" '");
        OrientODataUtils.byPackageId(q, id);
        OrientODataUtils.includePrerelease(q, query);
        QueryInfo odata = OrientODataUtils.parseQuery(query);
        NugetJPQLGenerator generator = new NugetJPQLGenerator(null, null, (Map<String, String>)COLUMN_ALIASES);
        if (odata.filter != null) {
            if (q.hasWhere()) {
                q.where(" AND ");
            }
            q.where("(").where(generator.toJpql(odata.filter)).where(")");
        }
        if (odata.skipToken != null) {
            if (q.hasWhere()) {
                q.where(" AND ");
            }
            q.where(" (").where(generator.toJpql(JPASkipToken.parse(null, (List)odata.orderBy, (String)odata.skipToken, (String[])new String[]{"id", "version"}))).where(")");
        }
        if (!groupBy.isEmpty()) {
            q.suffix(" GROUP BY ");
            q.suffix(String.join((CharSequence)", ", groupBy));
        }
        if (!count) {
            q.suffix(" ORDER BY ");
            if (odata.orderBy != null) {
                int i = 0;
                int size = odata.orderBy.size();
                while (i < size) {
                    OrderByExpression o = (OrderByExpression)odata.orderBy.get(i);
                    q.suffix(generator.toJpql(o.getExpression()));
                    if (o.getDirection() == OrderByExpression.Direction.ASCENDING) {
                        q.suffix(" ASC");
                    } else if (o.getDirection() == OrderByExpression.Direction.DESCENDING) {
                        q.suffix(" DESC");
                    }
                    q.suffix(", ");
                    ++i;
                }
            }
            q.suffix(String.valueOf((String)COLUMN_ALIASES.get((Object)"ID")) + " ASC, ");
            q.suffix(String.valueOf((String)COLUMN_ALIASES.get((Object)"VERSION")) + " ASC");
            q.suffix(" LIMIT " + OrientODataUtils.pageSize(odata));
            if (odata.skip != null) {
                q.suffix(" OFFSET " + odata.skip);
            }
        }
        return q.build();
    }

    public static int pageSize(QueryInfo odata) {
        int pageSize = 40;
        if (odata.top != null && odata.top < pageSize) {
            pageSize = odata.top;
        }
        return pageSize;
    }

    public static QueryInfo parseQuery(Map<String, String> query) {
        try {
            return new QueryInfo(null, OptionsQueryParser.parseTop((String)query.get("$top")), OptionsQueryParser.parseSkip((String)query.get("$skip")), OptionsQueryParser.parseFilter((String)query.get("$filter")), OptionsQueryParser.parseOrderBy((String)query.get("$orderby")), OptionsQueryParser.parseSkipToken((String)query.get("$skiptoken")), null, null, null);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Bad Request - Error in query syntax.", e);
        }
    }

    public static void includePrerelease(Query.Builder q, Map<String, String> query) {
        if ("false".equalsIgnoreCase(OrientODataUtils.getSanitizedValue(query, "includePrerelease"))) {
            if (q.hasWhere()) {
                q.where(" AND ");
            }
            q.where(" " + OrientODataUtils.jsonAttrib("ISPRERELEASE") + "=false ");
        }
    }

    public static void byPackageId(Query.Builder q, String id) {
        if (id != null) {
            if (q.hasWhere()) {
                q.where(" AND ");
            }
            q.where(String.valueOf(OrientODataUtils.jsonAttrib("ID")) + " = ").param((Object)id.toLowerCase(Locale.ENGLISH));
        }
    }

    @Nonnull
    private static Map<String, String> applyQueryDefaults(Map<String, String> originalQuery) {
        CaseInsensitiveMap query = new CaseInsensitiveMap(originalQuery);
        if (!query.containsKey("$orderby")) {
            query.put("$orderby", "DOWNLOADCOUNT desc");
        } else {
            String orderby = (String)query.get("$orderby");
            query.put("$orderby", orderby.replaceAll("(?i)concat\\(title,id\\)", "NAME_ORDER"));
        }
        if (query.containsKey("$filter")) {
            String filter = (String)query.get("$filter");
            query.put("$filter", OrientODataUtils.applyQueryDefaultsToFilterParam(filter));
        }
        return query;
    }

    public static String applyQueryDefaultsToFilterParam(String filter) {
        if (StringUtils.isEmpty((String)filter)) {
            return filter;
        }
        return filter.replaceAll("(?i)IsLatestVersion eq True", "IsLatestVersion").replaceAll("(?i)IsAbsoluteLatestVersion eq True", "IsAbsoluteLatestVersion").replaceAll("(?i)(IsLatestVersion|IsAbsoluteLatestVersion)", "($1 eq true)");
    }

    private static String jsonAttrib(String elementName) {
        return (String)COLUMN_ALIASES.get((Object)elementName);
    }

    public static String nugat(String column) {
        return "attributes.nuget." + column;
    }

    private static String getSanitizedValue(Map<String, String> query, String key) {
        return StringUtils.strip((String)query.getOrDefault(key, ""), (String)"\" '");
    }

    private static ImmutableMap<String, String> columnAliases() {
        HashMap aliases = Maps.newHashMap();
        aliases.put("CREATED", OrientODataUtils.nugat("created"));
        aliases.put("DOWNLOADCOUNT", OrientODataUtils.nugat("download_count"));
        aliases.put("ID", "component.ci_name");
        aliases.put("ISABSOLUTELATESTVERSION", OrientODataUtils.nugat("is_absolute_latest_version"));
        aliases.put("ISLATESTVERSION", OrientODataUtils.nugat("is_latest_version"));
        aliases.put("ISPRERELEASE", OrientODataUtils.nugat("is_prerelease"));
        aliases.put("LASTUPDATED", OrientODataUtils.nugat("last_updated"));
        aliases.put("NAME_ORDER", OrientODataUtils.nugat("name_order"));
        aliases.put("PACKAGEHASH", OrientODataUtils.nugat("package_hash"));
        aliases.put("PACKAGEHASHALGORITHM", OrientODataUtils.nugat("package_hash_algorithm"));
        aliases.put("PACKAGESIZE", OrientODataUtils.nugat("package_size"));
        aliases.put("PUBLISHED", OrientODataUtils.nugat("published"));
        aliases.put("REQUIRELICENSEACCEPTANCE", OrientODataUtils.nugat("require_license_acceptance"));
        aliases.put("SUMMARY", OrientODataUtils.nugat("summary"));
        aliases.put("TITLE", OrientODataUtils.nugat("title"));
        aliases.put("VERSION", "component.version");
        aliases.put("VERSIONDOWNLOADCOUNT", OrientODataUtils.nugat("version_download_count"));
        return ImmutableMap.copyOf((Map)aliases);
    }

    public static Query packageVersionsQuery(String packageId, Map<String, String> originalQuery) {
        CaseInsensitiveMap query = new CaseInsensitiveMap(originalQuery);
        Query.Builder q = Query.builder();
        OrientODataUtils.byPackageId(q, packageId);
        OrientODataUtils.includePrerelease(q, (Map<String, String>)query);
        return q.build();
    }

    public static int pageSize(Map<String, String> query) {
        return OrientODataUtils.pageSize(OrientODataUtils.parseQuery(query));
    }

    public static Optional<List<String>> idsForSimplifiedQueries(Map<String, String> query) {
        if (query.get("searchTerm") != null || query.get("id") != null || query.get("includePrerelease") != null) {
            return Optional.empty();
        }
        QueryInfo odata = OrientODataUtils.parseQuery(query);
        return OrientODataUtils.idsForSimplifiedQuery((CommonExpression)odata.filter);
    }

    private static Optional<List<String>> idsForSimplifiedQuery(CommonExpression expr) {
        if (expr instanceof OrExpression) {
            OrExpression orExpr = (OrExpression)expr;
            Optional<List<String>> lhs = OrientODataUtils.idsForSimplifiedQuery((CommonExpression)orExpr.getLHS());
            Optional<List<String>> rhs = OrientODataUtils.idsForSimplifiedQuery((CommonExpression)orExpr.getRHS());
            if (lhs.isPresent() && rhs.isPresent()) {
                return Optional.of(Stream.concat(lhs.get().stream(), rhs.get().stream()).collect(Collectors.toList()));
            }
        } else {
            if (expr instanceof ToLowerMethodCallExpression) {
                return OrientODataUtils.idsForSimplifiedQuery(((ToLowerMethodCallExpression)expr).getTarget());
            }
            if (expr instanceof ParenExpression) {
                return OrientODataUtils.idsForSimplifiedQuery(((ParenExpression)expr).getExpression());
            }
            if (expr instanceof BoolParenExpression) {
                return OrientODataUtils.idsForSimplifiedQuery(((BoolParenExpression)expr).getExpression());
            }
            if (expr instanceof EqExpression) {
                EqExpression eqExpr = (EqExpression)expr;
                Optional<List<String>> lhs = OrientODataUtils.idsForSimplifiedQuery(eqExpr.getLHS());
                if (lhs.isPresent() && eqExpr.getRHS() instanceof StringLiteral) {
                    StringLiteral stringLiteral = (StringLiteral)eqExpr.getRHS();
                    return Optional.of(Stream.concat(lhs.get().stream(), Stream.of(stringLiteral.getValue())).collect(Collectors.toList()));
                }
            } else if (expr instanceof EntitySimpleProperty && "ID".equalsIgnoreCase(((EntitySimpleProperty)expr).getPropertyName())) {
                return Optional.of(Collections.emptyList());
            }
        }
        return Optional.empty();
    }

    private static class NugetJPQLGenerator
    extends JPQLGenerator {
        private static final String ID_FIELD = "component.ci_name";
        private static final String VERSION_FIELD = "component.version";
        private static final String OPERATOR_EQ = "=";
        private static final String OPERATOR_NE = "<>";
        private static final String OPERATOR_GE = ">=";
        private static final String OPERATOR_LE = "<=";
        private static final String OPERATOR_GT = ">";
        private static final String OPERATOR_LT = "<";
        private static final List<String> OPERATORS = ImmutableList.of((Object)"=", (Object)"<>", (Object)">=", (Object)"<=", (Object)">", (Object)"<");
        private static final String SINGLE_QUOTE = "'";
        private static final String DOUBLE_SINGLE_QUOTE = "''";
        private static final String SINGLE_SPACE = " ";
        private static final List<String> ID_ALTERNATIVES = NugetJPQLGenerator.buildAlternatives("component.ci_name");
        private static final List<String> VERSION_ALTERNATIVES = NugetJPQLGenerator.buildAlternatives("component.version");

        NugetJPQLGenerator(String primaryKeyName, String tableAlias, Map<String, String> fieldAliases) {
            super(primaryKeyName, tableAlias, fieldAliases);
        }

        public String toJpql(BoolCommonExpression expression) {
            String result = super.toJpql(expression);
            if (this.hasMatch(result, ID_FIELD, ID_ALTERNATIVES)) {
                return result.toLowerCase(Locale.ENGLISH);
            }
            if (this.hasMatch(result, VERSION_FIELD, VERSION_ALTERNATIVES)) {
                return result.toLowerCase(Locale.ENGLISH).replaceAll("^component.version", "LOWER(component.version)").replaceAll("component.version$", "LOWER(component.version)");
            }
            return result;
        }

        private boolean hasMatch(String result, String field, List<String> alternatives) {
            return this.hasStartingMatch(result, field, alternatives) || this.hasEndingMatch(result, field, alternatives);
        }

        private boolean hasStartingMatch(String result, String field, List<String> alternatives) {
            return result.startsWith(field) && result.endsWith(SINGLE_QUOTE) && alternatives.stream().filter(a -> a.startsWith(field) && result.startsWith((String)a)).anyMatch(a -> this.hasStringLiteralMatch(result.substring(a.length() - 1)));
        }

        private boolean hasEndingMatch(String result, String field, List<String> alternatives) {
            return result.endsWith(field) && result.startsWith(SINGLE_QUOTE) && alternatives.stream().filter(a -> a.endsWith(field) && result.endsWith((String)a)).anyMatch(a -> this.hasStringLiteralMatch(result.substring(0, result.length() - a.length() + 1)));
        }

        private boolean hasStringLiteralMatch(String result) {
            if (DOUBLE_SINGLE_QUOTE.equals(result)) {
                return true;
            }
            String stringPortion = result.replaceAll(DOUBLE_SINGLE_QUOTE, "");
            return stringPortion.length() >= 2 && stringPortion.startsWith(SINGLE_QUOTE) && stringPortion.endsWith(SINGLE_QUOTE) && !stringPortion.substring(1, stringPortion.length() - 1).contains(SINGLE_QUOTE);
        }

        private static List<String> buildAlternatives(String field) {
            return Collections.unmodifiableList(OPERATORS.stream().map(operator -> SINGLE_SPACE + operator + SINGLE_SPACE).flatMap(str -> Stream.of(String.valueOf(field) + str + SINGLE_QUOTE, SINGLE_QUOTE + str + field)).collect(Collectors.toList()));
        }
    }
}

