/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.orient.internal.v2;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.sonatype.nexus.repository.nuget.QueryCacheKey;
import com.sonatype.nexus.repository.nuget.internal.CountReportingPolicy;
import com.sonatype.nexus.repository.nuget.internal.NugetFeedFetcher;
import com.sonatype.nexus.repository.nuget.internal.v2.FeedResult;
import com.sonatype.nexus.repository.nuget.orient.internal.OrientNugetAssetStateValidator;
import com.sonatype.nexus.repository.nuget.orient.internal.v2.OrientNugetLocalGalleryFacetSupport;
import com.sonatype.nexus.repository.nuget.v2.NugetGalleryFacet;
import com.sonatype.nexus.repository.nuget.v2.NugetV2CachingGalleryFacet;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.cache.Cache;
import javax.cache.expiry.CreatedExpiryPolicy;
import javax.cache.expiry.Duration;
import javax.inject.Inject;
import javax.inject.Named;
import javax.validation.constraints.NotNull;
import org.apache.http.client.utils.URIBuilder;
import org.sonatype.goodies.common.Time;
import org.sonatype.nexus.cache.CacheHelper;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.time.Clock;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.config.ConfigurationFacet;
import org.sonatype.nexus.repository.httpclient.RemoteBlockedIOException;
import org.sonatype.nexus.repository.routing.RoutingRuleHelper;
import org.sonatype.nexus.repository.storage.ComponentDeletedEvent;
import org.sonatype.nexus.repository.view.Payload;

public abstract class OrientNugetRemoteGalleryFacetSupport
extends OrientNugetLocalGalleryFacetSupport
implements NugetV2CachingGalleryFacet {
    private static final int TWO_PAGES = 80;
    protected final NugetFeedFetcher fetcher;
    private RoutingRuleHelper routingRuleHelper;
    @VisibleForTesting
    static final String CONFIG_KEY = "nugetProxy";
    private Config config;
    private Cache<QueryCacheKey, Integer> cache;
    private final CacheHelper cacheHelper;

    @Inject
    public OrientNugetRemoteGalleryFacetSupport(NugetFeedFetcher fetcher, CacheHelper cacheHelper, RoutingRuleHelper routingRuleHelper, OrientNugetAssetStateValidator assetStateValidator, Clock clock, @Named(value="${nexus.nuget.allow.multiple.latest:-true}") @Named(value="${nexus.nuget.allow.multiple.latest:-true}") boolean isLatestMultipleAllowed) {
        super(assetStateValidator, clock, isLatestMultipleAllowed);
        this.fetcher = (NugetFeedFetcher)((Object)Preconditions.checkNotNull((Object)((Object)fetcher)));
        this.cacheHelper = (CacheHelper)Preconditions.checkNotNull((Object)cacheHelper);
        this.routingRuleHelper = (RoutingRuleHelper)Preconditions.checkNotNull((Object)routingRuleHelper);
    }

    protected void doValidate(Configuration configuration) throws Exception {
        ((ConfigurationFacet)this.facet(ConfigurationFacet.class)).validateSection(configuration, CONFIG_KEY, Config.class, new Class[0]);
    }

    protected void doConfigure(Configuration configuration) throws Exception {
        this.config = (Config)((ConfigurationFacet)this.facet(ConfigurationFacet.class)).readSection(configuration, CONFIG_KEY, Config.class);
        this.log.debug("Config: {}", (Object)this.config);
    }

    @Override
    protected void doInit(Configuration configuration) throws Exception {
        super.doInit(configuration);
        this.maybeCreateCache();
    }

    protected void doUpdate(Configuration configuration) throws Exception {
        Config previous = this.config;
        super.doUpdate(configuration);
        if (!this.config.queryCacheItemMaxAge.equals(previous.queryCacheItemMaxAge)) {
            this.maybeDestroyCache();
            this.maybeCreateCache();
        }
    }

    protected void doDelete() throws Exception {
        this.maybeDestroyCache();
        this.config = null;
    }

    protected void doDestroy() throws Exception {
        this.cache = null;
        this.config = null;
    }

    @Subscribe
    @AllowConcurrentEvents
    @Guarded(by={"STARTED"})
    public void onComponentDeleted(ComponentDeletedEvent deleted) {
        if (deleted.isLocal() && this.matchesInvalidateCachesRepository(deleted.getRepositoryName())) {
            this.invalidateCaches();
        }
    }

    private boolean matchesInvalidateCachesRepository(String name) {
        return this.getRepositories().stream().anyMatch(repository -> repository.getName().equals(name) && !"hosted".equals(repository.getType().getValue()));
    }

    private void maybeCreateCache() {
        if (this.cache == null) {
            this.log.debug("Creating odata-query-cache for: {}", (Object)this.getRepository());
            this.cache = this.cacheHelper.maybeCreateCache(this.getCacheName(), QueryCacheKey.class, Integer.class, CreatedExpiryPolicy.factoryOf((Duration)new Duration(TimeUnit.SECONDS, (long)this.config.queryCacheItemMaxAge.intValue())));
            this.log.debug("Created odata-query-cache: {}", this.cache);
        }
    }

    @Override
    public String getCacheName() {
        return String.valueOf(this.getRepository().getName()) + "#odata-query-cache";
    }

    private void maybeDestroyCache() {
        if (this.cache != null) {
            this.log.debug("Destroying odata-query-cache for: {}", (Object)this.getRepository());
            this.cacheHelper.maybeDestroyCache(this.getCacheName());
            this.cache = null;
        }
    }

    @Override
    public int count(String operation, Map<String, String> parameters) {
        Iterable<Repository> proxyRepositories = this.getProxyRepositories();
        List<Integer> remoteCounts = this.passQueryToRemoteRepos(this.nugetQuery(operation, parameters), proxyRepositories, new CountFetcher());
        this.log.debug("Counts from proxyRepositories: {} are: {}", proxyRepositories, remoteCounts);
        Iterable<Repository> hostedRepositories = this.getHostedRepositories();
        int hostedCount = !Iterables.isEmpty(hostedRepositories) ? this.count(operation, parameters, hostedRepositories) : 0;
        this.log.debug("Counts from hostedRepositories: {} are: {}", hostedRepositories, (Object)hostedCount);
        return this.sum(remoteCounts) + hostedCount;
    }

    @Override
    protected String doFeed(String base, String operation, Map<String, String> query) {
        Integer top = this.asInteger(query.get("$top"));
        Integer skip = this.asInteger(query.get("$skip"));
        Map<String, String> remoteQuery = this.modifyQueryForRemote(operation, query, top, skip);
        List<Integer> remoteCounts = this.passQueryToRemoteRepos(this.nugetQuery(operation, remoteQuery), this.getProxyRepositories(), new FeedLoader());
        FeedResult localResult = this.queryFeed(base, operation, query, this.getRepositories());
        int localCount = (Integer)MoreObjects.firstNonNull((Object)localResult.getCount(), (Object)0);
        int reportedCount = CountReportingPolicy.determineReportedCount(remoteCounts, localCount, top, skip);
        if ("Search".equals(operation)) {
            reportedCount = Integer.min(40, reportedCount);
        }
        localResult.setCount(reportedCount);
        return this.renderFeedResults(localResult);
    }

    @Override
    public String packageVersions(String base, String id, Map<String, String> parameters) {
        TreeSet<String> versions = new TreeSet<String>();
        try {
            URI path = this.nugetQuery("package-versions/" + id, parameters);
            for (Repository repository : this.getProxyRepositories()) {
                if (!this.isAllowed(repository, path.toString())) continue;
                Throwable throwable = null;
                Object var9_11 = null;
                try (Payload payload = this.fetcher.getRemotePayload(repository, path);){
                    if (payload == null) continue;
                    versions.addAll((Collection)mapper.readValue(payload.openInputStream(), STRING_LIST));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            versions.addAll(this.packageVersions(base, id, parameters, this.getHostedRepositories()));
            return this.jsonString(versions);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private Map<String, String> modifyQueryForRemote(String operation, Map<String, String> query, Integer top, Integer skip) {
        HashMap remoteQuery = Maps.newHashMap(query);
        if ("Search".equals(operation) && top != null && skip != null) {
            remoteQuery.put("$top", "80");
            remoteQuery.put("$skip", "0");
        } else if (top == null || top > 80) {
            remoteQuery.put("$top", "80");
        }
        return remoteQuery;
    }

    @Override
    public String entry(String base, String id, String version) {
        Map<String, ?> entryData = this.queryEntry(base, id, version);
        if (entryData == null) {
            String remoteQuery = "Packages(Id='" + id + "',Version='" + version + "')";
            this.passQueryToRemoteRepos(this.nugetQuery(remoteQuery), this.getProxyRepositories(), new FeedLoader());
            entryData = this.queryEntry(base, id, version);
        }
        return this.renderEntryResult(entryData);
    }

    private URI nugetQuery(String path) {
        return this.nugetQuery(path, Collections.emptyMap());
    }

    private URI nugetQuery(String path, Map<String, String> queryParams) {
        try {
            URIBuilder uri = new URIBuilder();
            uri.setPath(path);
            if (!queryParams.isEmpty()) {
                ArrayList paramClauses = Lists.newArrayList();
                for (Map.Entry<String, String> param : queryParams.entrySet()) {
                    paramClauses.add(String.valueOf(param.getKey()) + "=" + param.getValue());
                }
                uri.setCustomQuery(Joiner.on((char)'&').join((Iterable)paramClauses));
            }
            return uri.build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private List<Integer> passQueryToRemoteRepos(URI path, Iterable<Repository> repositories, CachePopulator cachePopulator) {
        ArrayList<Integer> counts = new ArrayList<Integer>();
        for (Repository repo : repositories) {
            if (!this.isAllowed(repo, path.toString())) continue;
            try {
                QueryCacheKey key = new QueryCacheKey(repo.getName(), path);
                Integer cachedCount = (Integer)this.cache.get((Object)key);
                if (cachedCount == null) {
                    cachedCount = cachePopulator.call(repo, path);
                    this.cache.put((Object)key, (Object)cachedCount);
                }
                counts.add(cachedCount);
            }
            catch (UncheckedExecutionException | ExecutionException e) {
                this.log.warn("Exception attempting to contact proxied repository {}.", (Object)repo.getName(), (Object)e.getCause());
            }
            catch (RemoteBlockedIOException e) {
                this.log.trace("Failed to fetch from repository: {}", (Object)repo.getName(), (Object)e);
            }
            catch (IOException e) {
                this.log.trace("Failed to fetch, from repository: {}", (Object)repo.getName(), (Object)e);
            }
            catch (Exception e) {
                this.log.warn("Exception attempting to contact proxied repository {}.", (Object)repo.getName(), (Object)e);
            }
        }
        return counts;
    }

    @Nullable
    private Integer asInteger(String value) {
        if (value == null) {
            return null;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private int sum(Iterable<Integer> values) {
        int total = 0;
        for (Integer i : values) {
            total += ((Integer)Preconditions.checkNotNull((Object)i)).intValue();
        }
        return total;
    }

    @Override
    @Guarded(by={"STARTED"})
    public void invalidateCaches() {
        this.cache.clear();
    }

    private boolean isAllowed(Repository repository, String path) {
        return this.routingRuleHelper.isAllowed(repository, path);
    }

    private static interface CachePopulator {
        public Integer call(Repository var1, URI var2) throws Exception;
    }

    @VisibleForTesting
    static class Config {
        public static final int DEFAULT_QUERY_CACHE_ITEM_AGE = Time.minutes((long)60L).toSecondsI();
        @NotNull
        public Integer queryCacheItemMaxAge = DEFAULT_QUERY_CACHE_ITEM_AGE;

        Config() {
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + "{" + "queryCacheItemMaxAge=" + this.queryCacheItemMaxAge + '}';
        }
    }

    private class CountFetcher
    implements CachePopulator {
        private CountFetcher() {
        }

        @Override
        public Integer call(Repository remote, URI nugetQuery) throws Exception {
            return (Integer)MoreObjects.firstNonNull((Object)OrientNugetRemoteGalleryFacetSupport.this.fetcher.getCount(remote, nugetQuery), (Object)0);
        }
    }

    private class FeedLoader
    implements CachePopulator {
        private FeedLoader() {
        }

        @Override
        public Integer call(Repository remote, URI nugetQuery) throws Exception {
            NugetGalleryFacet gallery = (NugetGalleryFacet)remote.facet(NugetGalleryFacet.class);
            return (Integer)MoreObjects.firstNonNull((Object)OrientNugetRemoteGalleryFacetSupport.this.fetcher.cachePackageFeed(remote, nugetQuery, false, gallery::putMetadata), (Object)0);
        }
    }
}

