/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.orient.internal.v2;

import com.sonatype.nexus.repository.nuget.NugetPackageCoords;
import com.sonatype.nexus.repository.nuget.internal.NugetFeedFetcher;
import com.sonatype.nexus.repository.nuget.internal.NugetProxy;
import com.sonatype.nexus.repository.nuget.orient.internal.OrientNugetAssetStateValidator;
import com.sonatype.nexus.repository.nuget.orient.internal.OrientNugetProxyFacet;
import com.sonatype.nexus.repository.nuget.orient.internal.v2.OrientNugetRemoteGalleryFacetSupport;
import com.sonatype.nexus.repository.nuget.v2.NugetGalleryFacet;
import java.io.IOException;
import java.net.URI;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.cache.CacheHelper;
import org.sonatype.nexus.common.time.Clock;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.routing.RoutingRuleHelper;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;

@Named(value="proxyV2")
@Facet.Exposed
public class OrientNugetProxyGalleryFacetImpl
extends OrientNugetRemoteGalleryFacetSupport
implements NugetGalleryFacet,
NugetProxy {
    public static final String NAME = "proxyV2";

    @Inject
    public OrientNugetProxyGalleryFacetImpl(NugetFeedFetcher fetcher, CacheHelper cacheHelper, RoutingRuleHelper routingRuleHelper, OrientNugetAssetStateValidator assetStateValidator, Clock clock, @Named(value="${nexus.nuget.allow.multiple.latest:-true}") @Named(value="${nexus.nuget.allow.multiple.latest:-true}") boolean isLatestMultipleAllowed) {
        super(fetcher, cacheHelper, routingRuleHelper, assetStateValidator, clock, isLatestMultipleAllowed);
    }

    @Override
    public String getUrl(Context context) {
        return context.getRequest().getPath().substring(1);
    }

    @Override
    public Content fetch(Context context, Content stale) throws IOException {
        NugetPackageCoords coords = this.coords(context);
        String suffix = "Packages(Id='" + coords.getId() + "',Version='" + coords.getVersion() + "')";
        OrientNugetProxyFacet orientNugetProxyFacet = (OrientNugetProxyFacet)this.getRepository().facet(OrientNugetProxyFacet.class);
        URI remoteEntryUri = orientNugetProxyFacet.getRemoteUrl().resolve(suffix);
        StringBuilder contentLocation = new StringBuilder();
        this.fetcher.cachePackageFeed(this.getRepository(), remoteEntryUri, false, data -> {
            if (contentLocation.length() == 0) {
                contentLocation.append((String)data.get("LOCATION"));
            }
            this.putMetadata(data);
        });
        if (contentLocation.length() == 0) {
            this.log.debug("Proxy repo {} found no package entry for {} {} at remote", new Object[]{this.getRepository().getName(), coords.getId(), coords.getVersion()});
            return null;
        }
        return orientNugetProxyFacet.fetch(contentLocation.toString(), context, stale);
    }
}

