/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.orient.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.nuget.NugetPackageException;
import com.sonatype.nexus.repository.nuget.internal.AbstractNugetPushHandler;
import com.sonatype.nexus.repository.nuget.odata.NugetPackageUtils;
import com.sonatype.nexus.repository.nuget.v2.NugetGalleryFacet;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.security.SecurityFacet;
import org.sonatype.nexus.repository.storage.DatabaseThreadUtils;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.payloads.TempBlob;

public class OrientNugetPushHandler
extends AbstractNugetPushHandler {
    @Override
    protected void storePayload(Context context, Payload payload) throws IOException, NugetPackageException {
        Repository repository = context.getRepository();
        NugetGalleryFacet galleryFacet = (NugetGalleryFacet)repository.facet(NugetGalleryFacet.class);
        StorageFacet storageFacet = (StorageFacet)repository.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var7_8 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob(payload, NugetPackageUtils.HASH_ALGORITHMS);){
            Map<String, String> metadata;
            Throwable throwable2 = null;
            Object var11_13 = null;
            try (InputStream in = tempBlob.get();){
                metadata = NugetPackageUtils.packageMetadata(in);
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
            this.ensurePermissions(context, metadata.get("ID"), metadata.get("VERSION"));
            galleryFacet.put(metadata, tempBlob);
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void ensurePermissions(Context context, String packageId, String version) {
        Preconditions.checkNotNull((Object)packageId);
        Preconditions.checkNotNull((Object)version);
        String path = String.format("/%s/%s", packageId, version);
        Request changedRequest = new Request.Builder().copy(context.getRequest()).path(path).build();
        DatabaseThreadUtils.withOtherDatabase(() -> {
            ((SecurityFacet)context.getRepository().facet(SecurityFacet.class)).ensurePermitted(changedRequest);
            return null;
        });
    }
}

