/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.orient.internal;

import com.google.common.annotations.VisibleForTesting;
import com.sonatype.nexus.repository.nuget.NugetPackageCoords;
import com.sonatype.nexus.repository.nuget.internal.AbstractNugetHandler;
import com.sonatype.nexus.repository.nuget.internal.NugetHandlerUtils;
import com.sonatype.nexus.repository.nuget.v2.NugetGalleryFacet;
import java.io.IOException;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.Response;

public class OrientNugetItemHandler
extends AbstractNugetHandler {
    @Override
    protected Response doHandle(Context context) throws Exception {
        Request request = context.getRequest();
        String action = request.getAction();
        NugetPackageCoords coords = NugetHandlerUtils.getPackageCoordinates(context);
        switch (action) {
            case "GET": {
                return this.getItem(coords.getId(), coords.getVersion(), context);
            }
            case "DELETE": {
                return this.deleteItem(coords.getId(), coords.getVersion(), context);
            }
        }
        return HttpResponses.methodNotAllowed((String)action, (String[])new String[]{"GET", "DELETE"});
    }

    @VisibleForTesting
    Response getItem(String id, String version, Context context) throws IOException {
        NugetGalleryFacet facet = (NugetGalleryFacet)context.getRepository().facet(NugetGalleryFacet.class);
        Content payload = facet.get(id, version);
        if (payload == null) {
            return this.xmlErrorMessage(404, String.format("No such package: id=%s, version=%s", id, version));
        }
        return NugetHandlerUtils.buildPackageResponse(context, (Payload)payload);
    }

    @VisibleForTesting
    Response deleteItem(String id, String version, Context context) throws IOException {
        NugetGalleryFacet facet = (NugetGalleryFacet)context.getRepository().facet(NugetGalleryFacet.class);
        if (!facet.delete(id, version)) {
            return this.xmlErrorMessage(404, String.format("No such package: id=%s, version=%s", id, version));
        }
        return HttpResponses.noContent();
    }
}

