/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.orient.internal;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.repository.browse.BrowsePaths;
import org.sonatype.nexus.repository.browse.ComponentPathBrowseNodeGenerator;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Component;

@Singleton
@Named(value="nuget")
public class OrientNugetBrowseNodeGenerator
extends ComponentPathBrowseNodeGenerator {
    public List<BrowsePaths> computeAssetPaths(Asset asset, @Nullable Component component) {
        Preconditions.checkNotNull((Object)asset);
        if (asset.blobRef() == null) {
            return Collections.emptyList();
        }
        if (component != null) {
            List<BrowsePaths> paths = this.computeComponentPaths(asset, component);
            String packageName = this.packageName(component.name(), component.version());
            BrowsePaths.appendPath(paths, (String)packageName);
            return paths;
        }
        List paths = super.computeAssetPaths(asset, null);
        if (paths.size() == 2 && Character.isDigit(((BrowsePaths)paths.get(1)).getDisplayName().charAt(0))) {
            ((BrowsePaths)paths.get(1)).setRequestPath(String.valueOf(((BrowsePaths)paths.get(1)).getRequestPath()) + "/");
            String packageName = this.packageName(((BrowsePaths)paths.get(0)).getDisplayName(), ((BrowsePaths)paths.get(1)).getDisplayName());
            BrowsePaths.appendPath((List)paths, (String)packageName);
        }
        return paths;
    }

    public List<BrowsePaths> computeComponentPaths(Asset asset, Component component) {
        ArrayList<BrowsePaths> paths = new ArrayList<BrowsePaths>();
        if (asset.blobRef() == null) {
            return paths;
        }
        String requestPath = String.valueOf(component.name()) + "/";
        paths.add(new BrowsePaths(component.name(), requestPath));
        if (!Strings2.isBlank((String)component.version())) {
            requestPath = String.valueOf(requestPath) + component.version() + "/";
            paths.add(new BrowsePaths(component.version(), requestPath));
        }
        return paths;
    }

    private String packageName(String id, @Nullable String version) {
        if (!Strings2.isBlank((String)version)) {
            return String.format("%s-%s.nupkg", id, version);
        }
        return String.format("%s.nupkg", id);
    }
}

