/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.orient;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.Query;
import org.sonatype.nexus.repository.storage.StorageTx;

public class OrientNugetComponentHelper {
    private static final String P_VERSION_LOWERCASE = "version.toLowerCase()";

    private OrientNugetComponentHelper() {
    }

    public static void updateDerivedTextFields(Asset asset) {
        NestedAttributesMap nugetAttribs = asset.formatAttributes();
        Joiner joiner = Joiner.on((String)" ").skipNulls();
        String keywords = joiner.join(nugetAttribs.get("id", String.class), nugetAttribs.get("title", String.class), new Object[]{nugetAttribs.get("description", String.class), nugetAttribs.get("tags", String.class), nugetAttribs.get("authors", String.class)});
        nugetAttribs.set("keywords", (Object)keywords.toLowerCase());
        String value = String.valueOf(Strings.nullToEmpty((String)((String)nugetAttribs.get("title", String.class)))) + Strings.nullToEmpty((String)((String)nugetAttribs.get("id", String.class)));
        nugetAttribs.set("name_order", (Object)value.toLowerCase(Locale.ENGLISH));
    }

    @Nullable
    public static Component findComponent(StorageTx tx, String name, String version, Iterable<Repository> repositories) {
        return (Component)Iterables.getFirst((Iterable)tx.findComponents(Query.builder().where("ci_name").eq((Object)name.toLowerCase(Locale.ENGLISH)).and(P_VERSION_LOWERCASE).eq((Object)version.toLowerCase(Locale.ENGLISH)).build(), repositories), null);
    }

    public static Iterable<Component> findComponents(StorageTx tx, String name, Iterable<Repository> repositories) {
        return tx.findComponentsByNameCaseInsensitive(name, repositories, null);
    }

    public static Component createComponent(StorageTx tx, Repository repository, String packageId, String version) {
        return ((Component)tx.createComponent(tx.findBucket(repository), repository.getFormat()).name(packageId)).version(version);
    }

    public static String blobName(Component component) {
        return String.valueOf(component.name()) + "-" + component.requireVersion() + ".nupkg";
    }

    public static List<Component> findComponentByNameCaseInsensitive(String name, StorageTx tx, Repository repository) {
        Iterable components = tx.findComponentsByNameCaseInsensitive(name, Collections.singletonList(repository), null);
        if (components.iterator().hasNext()) {
            return StreamSupport.stream(components.spliterator(), false).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

