/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.odata;

import com.google.common.collect.ImmutableMap;
import com.sonatype.nexus.repository.nuget.odata.ODataTemplates;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class ODataFeedUtils {
    private static final DateTimeFormatter ISO_PRINTER = ISODateTimeFormat.dateTime().withLocale(Locale.ENGLISH).withZoneUTC();

    private ODataFeedUtils() {
    }

    public static String skipLinkQueryString(Map<String, String> query) {
        Map<String, String> nextPageQuery = ODataFeedUtils.queryForNextPage(query);
        return ODataFeedUtils.toQueryString(nextPageQuery);
    }

    @Nonnull
    private static String toQueryString(Map<String, String> nextPageQuery) {
        StringBuilder link = new StringBuilder();
        for (Map.Entry<String, String> entry : nextPageQuery.entrySet()) {
            if (link.length() > 0) {
                link.append("&");
            }
            link.append(entry.getKey()).append("=").append(ODataFeedUtils.encode(entry.getValue()));
        }
        return link.toString();
    }

    @Nonnull
    private static Map<String, String> queryForNextPage(Map<String, String> query) {
        HashMap<String, String> nextPageQuery = new HashMap<String, String>(query);
        if (query.containsKey("$top")) {
            int top = Integer.parseInt(query.get("$top"));
            nextPageQuery.put("$top", Integer.toString(Math.max(1, top - 40)));
        }
        int currentSkip = query.containsKey("$skip") ? Integer.parseInt(query.get("$skip")) : 0;
        nextPageQuery.put("$skip", Integer.toString(currentSkip + 40));
        return nextPageQuery;
    }

    private static String encode(String raw) {
        try {
            return URLEncoder.encode(raw, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String root(String base) {
        ImmutableMap data = ImmutableMap.of((Object)"BASEURI", (Object)base);
        return ODataTemplates.interpolate(ODataTemplates.NUGET_ROOT, data);
    }

    public static String metadata() {
        return ODataTemplates.NUGET_META;
    }

    public static String error(int code, String message) {
        ImmutableMap data = ImmutableMap.of((Object)"CODE", (Object)Integer.toString(code), (Object)"MESSAGE", (Object)message);
        return ODataTemplates.interpolate(ODataTemplates.NUGET_ERROR, data);
    }

    public static String datetime(long millis) {
        return ISO_PRINTER.print(millis);
    }

    public static String deprecated() {
        return ODataTemplates.NUGET_DEPRECATED;
    }
}

