/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.odata;

import com.google.common.collect.Lists;
import com.google.common.hash.HashCode;
import com.google.common.io.ByteStreams;
import com.sonatype.nexus.repository.nuget.NugetPackageException;
import com.sonatype.nexus.repository.nuget.odata.NuspecSplicer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.hash.MultiHashingInputStream;

public class NugetPackageUtils {
    public static final List<HashAlgorithm> HASH_ALGORITHMS = Lists.newArrayList((Object[])new HashAlgorithm[]{HashAlgorithm.SHA512, HashAlgorithm.SHA1});

    private NugetPackageUtils() {
    }

    public static Map<String, String> packageMetadata(InputStream inputStream) throws IOException, NugetPackageException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (MultiHashingInputStream hashingStream = new MultiHashingInputStream(HASH_ALGORITHMS, inputStream);){
                byte[] nuspec = NugetPackageUtils.extractNuspec((InputStream)hashingStream);
                Map<String, String> metadata = NuspecSplicer.extractNuspecData(new ByteArrayInputStream(nuspec));
                ByteStreams.copy((InputStream)hashingStream, (OutputStream)ByteStreams.nullOutputStream());
                metadata.put("PACKAGESIZE", String.valueOf(hashingStream.count()));
                HashCode code = (HashCode)hashingStream.hashes().get(HashAlgorithm.SHA512);
                metadata.put("PACKAGEHASH", new String(Base64.getEncoder().encode(code.asBytes()), StandardCharsets.UTF_8));
                metadata.put("PACKAGEHASHALGORITHM", "SHA512");
                return metadata;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (XmlPullParserException e) {
            throw new NugetPackageException("Unable to read .nuspec from package stream", e);
        }
    }

    public static boolean isV3Metadata(String name) {
        return name.endsWith(".json");
    }

    public static boolean isV3Package(String blobType) {
        return "application/octet-stream".equals(blobType);
    }

    private static byte[] extractNuspec(InputStream is) {
        try {
            ZipInputStream zis = new ZipInputStream(is);
            ZipEntry e = zis.getNextEntry();
            while (e != null) {
                if (e.getName().endsWith(".nuspec")) {
                    return ByteStreams.toByteArray((InputStream)zis);
                }
                e = zis.getNextEntry();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        throw new RuntimeException("Missing nuspec");
    }
}

