/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.odata;

import com.sonatype.nexus.repository.nuget.odata.ODataConsumer;
import com.sonatype.nexus.repository.nuget.odata.XmlSplicer;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FeedSplicer
extends XmlSplicer {
    private Map<String, String> data = new HashMap<String, String>();
    private final ODataConsumer consumer;
    private boolean isNull;
    private String next;
    private Integer count;
    private static final Logger log = LoggerFactory.getLogger(FeedSplicer.class);

    public FeedSplicer(ODataConsumer consumer) {
        super(new StringBuilder());
        this.consumer = consumer;
    }

    @Nullable
    public String consumePage(InputStream is) throws XmlPullParserException, IOException {
        this.next = null;
        this.count = null;
        this.consume((Reader)ReaderFactory.newXmlReader((InputStream)is));
        return this.next;
    }

    public Map<String, String> consumeEntry(InputStream is) throws XmlPullParserException, IOException {
        this.consume((Reader)ReaderFactory.newXmlReader((InputStream)is));
        return this.data;
    }

    @Nullable
    public Integer getCount() {
        return this.count;
    }

    @Override
    void started(String name, int len, boolean isRoot) throws XmlPullParserException {
        if (isRoot && !"feed".equals(name) && !"entry".equals(name)) {
            throw new XmlPullParserException("Parsed xml has an unexpected start tag: '" + name + "' (expected 'feed' or 'entry')");
        }
        if ("entry".equals(name)) {
            this.data = new HashMap<String, String>();
        } else if ("content".equals(name)) {
            this.data.put("LOCATION", this.getAttribute("src"));
        } else if ("link".equals(name) && "next".equals(this.getAttribute("rel"))) {
            this.next = this.getAttribute("href");
        } else {
            this.isNull = Boolean.parseBoolean(this.getAttribute("m:null"));
        }
        this.xml.setLength(0);
    }

    @Override
    void ended(String name, int len) {
        if ("entry".equals(name)) {
            if (this.consumer != null) {
                this.consumer.consume(FeedSplicer.sanitize(this.data));
            }
        } else if ("m:count".equals(name)) {
            String strCount = this.xml.substring(0, this.xml.length() - len);
            try {
                this.count = Integer.parseInt(strCount);
            }
            catch (NumberFormatException numberFormatException) {
                log.warn("Error parsing a nuget feed <m:count> with value {}", (Object)strCount);
            }
        } else if (!this.isNull) {
            String key = name.toUpperCase(Locale.ENGLISH);
            if (key.startsWith("D:")) {
                key = key.substring(2);
            } else if ("ID".equals(key)) {
                key = "ATOM_ID";
            } else if ("TITLE".equals(key)) {
                key = "ID";
            } else if ("NAME".equals(key)) {
                key = "AUTHORS";
            } else if ("UPDATED".equals(key)) {
                key = "LASTUPDATED";
            }
            this.data.put(key, this.xml.substring(0, this.xml.length() - len));
            this.isNull = true;
        }
    }

    private static Map<String, String> sanitize(Map<String, String> data) {
        if (!data.containsKey("CREATED")) {
            data.put("CREATED", data.get("LASTUPDATED"));
        }
        if (!data.containsKey("PUBLISHED")) {
            data.put("PUBLISHED", data.get("CREATED"));
        }
        if (!data.containsKey("DOWNLOADCOUNT")) {
            data.put("DOWNLOADCOUNT", "0");
        }
        if (!data.containsKey("VERSIONDOWNLOADCOUNT")) {
            data.put("VERSIONDOWNLOADCOUNT", data.get("DOWNLOADCOUNT"));
        }
        return data;
    }
}

