/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.internal.v3.routing;

import com.sonatype.nexus.repository.nuget.NugetPackageCoords;
import java.util.Objects;
import java.util.function.Consumer;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Matcher;
import org.sonatype.nexus.repository.view.matchers.RegexMatcher;

public class NugetMetadataMatcher
extends RegexMatcher {
    private static final String INDEX_JSON = "index.json";
    public static final String PACKAGE_KEY = "registrationPackageId";
    public static final String METADATA_KEY = "registrationPage";
    private static final String CERTIFICATE_FINGERPRINT_KEY = "certificateFingerPrint";
    private static final String REPOSITORY_SIGNATURES_PATH_KEY = "repositorySignaturesPath";
    private static final String REPOSITORY_SIGNATURES_SUFFIX_ID_KEY = "repositorySignaturesSuffixId";
    private static final String REGISTRATION_INDEX_PATTERN = "/v3/registration/(?:\\d+\\/)?(.+)\\/index.json";
    private static final String REGISTRATION_PAGE_PATTERN = "/v3/registration/(?:\\d+\\/)?page\\/(.+)";
    private static final String REGISTRATION_LEAF_PATTERN = "/v3/registration/(?:\\d+\\/)?(?!.+\\/index.json)(.+)";
    private static final String REGISTRATION_PAGE_LEAF_CATALOG_PATTERN = "/v3/catalog/(?:\\d+\\/)?(.*?)\\.((?:\\.?[0-9]+)(.*)?)\\.json$";
    private static final String REPOSITORY_SIGNATURES_PATTERN = "(/v3/repository-signatures/\\d+\\/)index.json";
    private static final String REPOSITORY_SIGNATURES_CERTIFICATES_PATTERN = "(/v3/repository-signatures/\\d+\\/)certificates/?(.+).crt";
    private final Consumer<Context> contextConsumer;

    public static Matcher serviceIndexMatcher() {
        return new RegexMatcher("/index.json(:?/*)");
    }

    public static Matcher repositorySignaturesMatcher() {
        return new NugetMetadataMatcher(REPOSITORY_SIGNATURES_PATTERN, context -> {
            String repositorySignaturesPath = ((RegexMatcher.State)context.getAttributes().require(RegexMatcher.State.class)).getMatchResult().group(1);
            context.getAttributes().set(REPOSITORY_SIGNATURES_SUFFIX_ID_KEY, (Object)(String.valueOf(repositorySignaturesPath) + INDEX_JSON));
            context.getAttributes().set(REPOSITORY_SIGNATURES_PATH_KEY, (Object)repositorySignaturesPath);
        });
    }

    public static NugetMetadataMatcher repositorySignaturesCertificatesMatcher() {
        return new NugetMetadataMatcher(REPOSITORY_SIGNATURES_CERTIFICATES_PATTERN, context -> {
            String repositorySignaturesPath = ((RegexMatcher.State)context.getAttributes().require(RegexMatcher.State.class)).getMatchResult().group(1);
            context.getAttributes().set(REPOSITORY_SIGNATURES_SUFFIX_ID_KEY, (Object)(String.valueOf(repositorySignaturesPath) + INDEX_JSON));
            context.getAttributes().set(REPOSITORY_SIGNATURES_PATH_KEY, (Object)repositorySignaturesPath);
            context.getAttributes().set(CERTIFICATE_FINGERPRINT_KEY, (Object)((RegexMatcher.State)context.getAttributes().require(RegexMatcher.State.class)).getMatchResult().group(2));
        });
    }

    public static NugetMetadataMatcher indexMatcher() {
        return new NugetMetadataMatcher(REGISTRATION_INDEX_PATTERN, context -> {
            Object object = context.getAttributes().set(PACKAGE_KEY, (Object)((RegexMatcher.State)context.getAttributes().require(RegexMatcher.State.class)).getMatchResult().group(1));
        });
    }

    public static NugetMetadataMatcher pageMatcher() {
        return new NugetMetadataMatcher(REGISTRATION_PAGE_PATTERN, context -> {
            Object object = context.getAttributes().set(METADATA_KEY, (Object)((RegexMatcher.State)context.getAttributes().require(RegexMatcher.State.class)).getMatchResult().group(1));
        });
    }

    public static NugetMetadataMatcher leafMatcher() {
        return new NugetMetadataMatcher(REGISTRATION_LEAF_PATTERN, context -> {
            Object object = context.getAttributes().set(METADATA_KEY, (Object)((RegexMatcher.State)context.getAttributes().require(RegexMatcher.State.class)).getMatchResult().group(1));
        });
    }

    public static NugetMetadataMatcher pageLeafCatalogMatcher() {
        return new NugetMetadataMatcher(REGISTRATION_PAGE_LEAF_CATALOG_PATTERN, context -> {
            String id = ((RegexMatcher.State)context.getAttributes().require(RegexMatcher.State.class)).getMatchResult().group(1);
            String version = ((RegexMatcher.State)context.getAttributes().require(RegexMatcher.State.class)).getMatchResult().group(2);
            context.getAttributes().set(NugetPackageCoords.class, (Object)new NugetPackageCoords(id, version));
        });
    }

    private NugetMetadataMatcher(String contentRegex, Consumer<Context> contextConsumer) {
        super(contentRegex);
        this.contextConsumer = Objects.requireNonNull(contextConsumer);
    }

    public boolean matches(Context context) {
        if (super.matches(context)) {
            this.contextConsumer.accept(context);
            return true;
        }
        return false;
    }

    public static String getMetadataPackageId(Context context) {
        return (String)context.getAttributes().require(PACKAGE_KEY, String.class);
    }

    public static String getMetadataPath(Context context) {
        return (String)context.getAttributes().require(METADATA_KEY, String.class);
    }

    public static String getCertificateFingerprint(Context context) {
        return (String)context.getAttributes().require(CERTIFICATE_FINGERPRINT_KEY, String.class);
    }

    public static String getRepositorySignaturesPath(Context context) {
        return (String)context.getAttributes().require(REPOSITORY_SIGNATURES_PATH_KEY, String.class);
    }

    public static String getRepositorySignaturesSuffixId(Context context) {
        return (String)context.getAttributes().require(REPOSITORY_SIGNATURES_SUFFIX_ID_KEY, String.class);
    }
}

