/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.internal.v3.routing;

import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.matchers.RegexMatcher;

public class NugetContentMatcher
extends RegexMatcher {
    public static final String PACKAGE_KEY = "nugetContentPackageKey";
    public static final String VERSION_KEY = "nugetContentVersionKey";
    private static final String CONTENT_ROUTE_REGEX_PATTERN = "/v3/content/(?:\\d+\\/)?(.+)\\/(.+)\\/.+\\.nupkg";
    private static final String CONTENT_MANIFEST_ROUTE_REGEX_PATTERN = "/v3/content/(?:\\d+\\/)?(.+)\\/(.+)\\/.+\\.nuspec";
    private static final String CONTENT_VERSIONS_ROUTE_REGEX_PATTERN = "/v3/content/(?:\\d+\\/)?(.+)index\\.json";
    private final int packageGroup;
    private final int versionGroup;

    public static NugetContentMatcher packageMatcher() {
        return new NugetContentMatcher(CONTENT_ROUTE_REGEX_PATTERN, 1, 2);
    }

    public static NugetContentMatcher manifestMatcher() {
        return new NugetContentMatcher(CONTENT_MANIFEST_ROUTE_REGEX_PATTERN, 1, 2);
    }

    public static NugetContentMatcher versionsMatcher() {
        return new NugetContentMatcher(CONTENT_VERSIONS_ROUTE_REGEX_PATTERN, 1, -1);
    }

    private NugetContentMatcher(String contentRegex, int packageGroup, int versionGroup) {
        super(contentRegex);
        this.packageGroup = packageGroup;
        this.versionGroup = versionGroup;
    }

    public boolean matches(Context context) {
        if (super.matches(context)) {
            context.getAttributes().set(PACKAGE_KEY, (Object)((RegexMatcher.State)context.getAttributes().require(RegexMatcher.State.class)).getMatchResult().group(this.packageGroup));
            if (this.versionGroup >= 0) {
                context.getAttributes().set(VERSION_KEY, (Object)((RegexMatcher.State)context.getAttributes().require(RegexMatcher.State.class)).getMatchResult().group(this.versionGroup));
            }
            return true;
        }
        return false;
    }

    public static String getContentPackageId(Context context) {
        return (String)context.getAttributes().require(PACKAGE_KEY, String.class);
    }

    public static String getContentVersion(Context context) {
        return (String)context.getAttributes().require(VERSION_KEY, String.class);
    }
}

