/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.internal.v3.packagemetadata;

import com.sonatype.nexus.repository.nuget.internal.v3.NugetV3ProxyUtil;
import com.sonatype.nexus.repository.nuget.v3.NugetServiceType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class NugetRegistrationsUtils {
    private static final Pattern TAG_TRIM_PATTERN = Pattern.compile("^[^\\w\\.]+|[^\\w\\.]+$");

    public static List<String> parseTags(String tagsAttrValue) {
        return StringUtils.isBlank((CharSequence)tagsAttrValue) ? Collections.emptyList() : Arrays.stream(tagsAttrValue.split("\\s")).map(s -> TAG_TRIM_PATTERN.matcher((CharSequence)s).replaceAll("")).distinct().collect(Collectors.toList());
    }

    public static String registrationPageLeafId(String repositoryUrl, String componentName, String componentVersion) {
        return NugetV3ProxyUtil.joinPath(repositoryUrl, "/v3/registration/", componentName, String.valueOf(componentVersion) + ".json");
    }

    public static String registrationPageParent(String repositoryUrl, String componentName) {
        return NugetV3ProxyUtil.joinPath(repositoryUrl, "/v3/registration/", componentName, "index.json");
    }

    public static String registrationPageParent(String repositoryUrl, String componentName, NugetServiceType serviceType) {
        return NugetV3ProxyUtil.joinPath(repositoryUrl, serviceType.getPath(), componentName, "index.json");
    }
}

