/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.internal.v3.packagemetadata;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sonatype.nexus.repository.nuget.NugetPackageCoords;
import com.sonatype.nexus.repository.nuget.internal.v3.NugetV3ProxyUtil;
import com.sonatype.nexus.repository.nuget.internal.v3.NugetV3SemVerComparator;
import com.sonatype.nexus.repository.nuget.internal.v3.NugetV3SemVerLeafComparator;
import com.sonatype.nexus.repository.nuget.internal.v3.packagemetadata.NugetRegistrationsUtils;
import com.sonatype.nexus.repository.nuget.odata.FrameworkNameUtils;
import com.sonatype.nexus.repository.nuget.v3.models.PageLeaf;
import com.sonatype.nexus.repository.nuget.v3.models.PageLeafCatalogEntry;
import com.sonatype.nexus.repository.nuget.v3.models.RegistrationIndex;
import com.sonatype.nexus.repository.nuget.v3.models.RegistrationLeaf;
import com.sonatype.nexus.repository.nuget.v3.models.RegistrationPage;
import java.io.IOException;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.StringPayload;

@Facet.Exposed
public abstract class NugetRegistrationsFacet
extends FacetSupport {
    protected final ObjectMapper mapper;

    protected NugetRegistrationsFacet(ObjectMapper mapper) {
        this.mapper = Objects.requireNonNull(mapper);
    }

    protected abstract Collection<ComponentContainer> getComponents(String var1);

    protected abstract Optional<ComponentContainer> getComponent(NugetPackageCoords var1);

    protected abstract Optional<RegistrationIndex> getCachedRegistrationIndex(String var1);

    protected abstract void storePayload(Payload var1, String var2) throws IOException;

    public Optional<RegistrationIndex> getRegistrationIndex(String packageId) {
        Objects.requireNonNull(packageId);
        Repository repository = this.getRepository();
        Optional<RegistrationIndex> maybeRegistrationIndex = this.getCachedRegistrationIndex(packageId);
        if (maybeRegistrationIndex.isPresent()) {
            return maybeRegistrationIndex;
        }
        maybeRegistrationIndex = this.buildRegistrationIndex(packageId);
        maybeRegistrationIndex.ifPresent(registrationIndex -> {
            try {
                Throwable throwable = null;
                Object var5_6 = null;
                try (StringPayload payload = new StringPayload(this.mapper.writeValueAsString(registrationIndex), "application/json");){
                    this.storePayload((Payload)payload, this.registrationIndexName(packageId));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                this.log.error("Unable to store registration index for package: {} in repository: {}", (Object)packageId, (Object)repository.getName());
            }
        });
        return maybeRegistrationIndex;
    }

    public Optional<RegistrationLeaf> getRegistrationLeaf(NugetPackageCoords nugetPackageCoords) {
        return this.getComponent(nugetPackageCoords).map(it -> {
            String packageId = it.getId().toLowerCase();
            String packageVersion = it.getVersion().toLowerCase();
            RegistrationLeaf registrationLeaf = new RegistrationLeaf();
            String id = NugetRegistrationsUtils.registrationPageLeafId(this.getRepository().getUrl(), packageId, packageVersion);
            registrationLeaf.setId(id);
            return registrationLeaf;
        });
    }

    public Optional<PageLeafCatalogEntry> getPageLeafCatalogEntry(NugetPackageCoords nugetPackageCoords) {
        return this.getComponent(nugetPackageCoords).map(it -> {
            NestedAttributesMap formatAttributes = it.getFormatAttributes();
            return this.createCatalogEntry(formatAttributes);
        });
    }

    protected Set<PageLeaf> getPageLeafs(String packageId) {
        Collection<ComponentContainer> packages = this.getComponents(packageId);
        return packages.stream().map(it -> {
            NestedAttributesMap formatAttributes = it.getFormatAttributes();
            String packageIdLower = it.getId().toLowerCase();
            String packageVersionLower = it.getVersion().toLowerCase();
            PageLeaf leaf = new PageLeaf();
            String repositoryUrl = this.getRepository().getUrl();
            leaf.setId(NugetRegistrationsUtils.registrationPageLeafId(repositoryUrl, packageIdLower, packageVersionLower));
            leaf.setPackageContent(NugetV3ProxyUtil.joinPath(repositoryUrl, "/v3/content/", packageIdLower, packageVersionLower, String.valueOf(packageIdLower) + "." + packageVersionLower + ".nupkg"));
            leaf.setCatalogEntry(this.createCatalogEntry(formatAttributes));
            return leaf;
        }).collect(Collectors.toCollection(() -> new TreeSet<PageLeaf>(NugetV3SemVerLeafComparator.INSTANCE)));
    }

    protected Optional<RegistrationIndex> buildRegistrationIndex(String packageId) {
        Objects.requireNonNull(packageId);
        Set<PageLeaf> pageLeaves = this.getPageLeafs(packageId);
        if (pageLeaves.isEmpty()) {
            return Optional.empty();
        }
        Repository repository = this.getRepository();
        RegistrationPage page = new RegistrationPage();
        page.setParent(NugetRegistrationsUtils.registrationPageParent(repository.getUrl(), packageId));
        page.getLeaves().addAll(pageLeaves);
        page.setCount(page.getLeaves().size());
        Set versions = pageLeaves.stream().map(pageLeaf -> pageLeaf.getCatalogEntry()).map(pageLeafCatalogEntry -> pageLeafCatalogEntry.getVersion()).collect(Collectors.toSet());
        page.setLower(Collections.min(versions, NugetV3SemVerComparator.INSTANCE));
        page.setUpper(Collections.max(versions, NugetV3SemVerComparator.INSTANCE));
        page.setId(NugetV3ProxyUtil.joinPath(String.valueOf(page.getParent()) + "#page", page.getLower().toLowerCase(), page.getUpper().toLowerCase()));
        RegistrationIndex index = new RegistrationIndex();
        index.setCount(1);
        index.setPages(Collections.singletonList(page));
        return Optional.of(index);
    }

    protected String registrationIndexName(String packageId) {
        return NugetV3ProxyUtil.joinPath("/v3/registration/", packageId.toLowerCase(), "index.json");
    }

    protected PageLeafCatalogEntry createCatalogEntry(NestedAttributesMap formatAttributes) {
        PageLeafCatalogEntry entry = new PageLeafCatalogEntry();
        String lowerId = formatAttributes.require("id").toString().toLowerCase();
        String lowerVersion = formatAttributes.require("version").toString().toLowerCase();
        String repositoryUrl = this.getRepository().getUrl();
        entry.setResourceId(NugetV3ProxyUtil.joinPath(repositoryUrl, "/v3/catalog/", String.valueOf(lowerId) + "." + lowerVersion + ".json"));
        entry.setAuthors(Collections.singletonList(formatAttributes.get("authors", (Object)"").toString()));
        entry.setDependencyGroups(FrameworkNameUtils.parseDependencyGroups(formatAttributes.get("dependencies", (Object)"").toString(), repositoryUrl));
        entry.setDescription(formatAttributes.get("description", (Object)"").toString());
        entry.setIconUrl(formatAttributes.get("icon_url", (Object)"").toString());
        entry.setId(formatAttributes.get("id", (Object)"").toString());
        if (formatAttributes.get("license_type", (Object)"").equals("expression")) {
            entry.setLicenseExpression(formatAttributes.get("license", (Object)"").toString());
        }
        entry.setLicenseUrl(formatAttributes.get("license_url", (Object)"").toString());
        entry.setListed(true);
        entry.setMinClientVersion(formatAttributes.get("min_client_version", (Object)"").toString());
        entry.setProjectUrl(formatAttributes.get("project_url", (Object)"").toString());
        Object published = formatAttributes.get("published");
        if (published instanceof Date) {
            entry.setPublished(Instant.ofEpochMilli(((Date)published).getTime()).toString());
        } else if (published instanceof String) {
            entry.setPublished((String)published);
        }
        entry.setRequireLicenseAcceptance((Boolean)formatAttributes.get("require_license_acceptance", Boolean.class, (Object)false));
        entry.setSummary(formatAttributes.get("summary", (Object)"").toString());
        entry.setTags(NugetRegistrationsUtils.parseTags(formatAttributes.get("tags", (Object)"").toString()));
        entry.setTitle(formatAttributes.get("title", (Object)"").toString());
        entry.setVersion(formatAttributes.get("version", (Object)"").toString());
        return entry;
    }

    public static class ComponentContainer {
        private final String id;
        private final String version;
        private final NestedAttributesMap formatAttributes;

        public ComponentContainer(String id, String version, NestedAttributesMap formatAttributes) {
            this.id = id;
            this.version = version;
            this.formatAttributes = formatAttributes;
        }

        public String getId() {
            return this.id;
        }

        public String getVersion() {
            return this.version;
        }

        public NestedAttributesMap getFormatAttributes() {
            return this.formatAttributes;
        }
    }
}

