/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.internal.v3;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.sonatype.nexus.repository.nuget.internal.v3.NugetV3SearchParam;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.search.AssetSearchResult;
import org.sonatype.nexus.repository.search.ComponentSearchResult;
import org.sonatype.nexus.repository.search.SearchRequest;
import org.sonatype.nexus.repository.search.SearchService;
import org.sonatype.nexus.repository.search.SortDirection;

@Facet.Exposed
public class NugetV3SearchFacet
extends FacetSupport {
    private static final String ASSET_ATTRIBUTE_PREFIX = "assets.attributes.nuget.";
    private static final String ATTRIBUTE_PREFIX = "attributes.nuget.";
    private static final String P_PACKAGE_ID = "packageid";
    private static final String AUTHOR = "author";
    private final SearchService searchService;
    private final String wildcardPattern;
    private final int maxBucketSize;
    private Map<String, String> exactFields;
    private Map<String, String> fields;
    private Set<String> keywordsFields;
    private String assetAttributeId;

    @Inject
    public NugetV3SearchFacet(SearchService searchService, @Named(value="${nexus.nuget.v3.search.maxBucketSize:-250}") @Named(value="${nexus.nuget.v3.search.maxBucketSize:-250}") int maxBucketSize, @Named(value="${nexus.datastore.table.search.enabled:-false}") @Named(value="${nexus.datastore.table.search.enabled:-false}") boolean sqlSearchEnabled) {
        this.searchService = (SearchService)Preconditions.checkNotNull((Object)searchService);
        this.maxBucketSize = maxBucketSize;
        this.wildcardPattern = sqlSearchEnabled ? "%s*" : "*%s*";
        this.configureSearchFields(sqlSearchEnabled);
    }

    private void configureSearchFields(boolean sqlSearchEnabled) {
        this.assetAttributeId = sqlSearchEnabled ? "attributes.nuget.id" : "assets.attributes.nuget.id";
        this.exactFields = ImmutableMap.of((Object)P_PACKAGE_ID, (Object)this.assetAttributeId);
        ImmutableMap matchFields = ImmutableMap.builder().put((Object)"id", (Object)this.assetAttributeId).put((Object)"title", (Object)"assets.attributes.nuget.title").put((Object)"tags", (Object)"assets.attributes.nuget.tags").put((Object)"authors", (Object)"assets.attributes.nuget.authors").put((Object)AUTHOR, (Object)"assets.attributes.nuget.authors").put((Object)"description", (Object)"assets.attributes.nuget.description").put((Object)"summary", (Object)"assets.attributes.nuget.summary").build();
        this.fields = ImmutableMap.builder().putAll(this.exactFields).putAll((Map)matchFields).build();
        this.keywordsFields = ImmutableSet.copyOf(this.fields.values());
    }

    private List<ComponentSearchResult> doSearch(QueryTerms queryTerms, int skip, int take) {
        SearchRequest.Builder requestBuilder = this.buildQuery(queryTerms).repository(this.getRepository().getName()).sortField(this.assetAttributeId).sortDirection(SortDirection.ASC).offset(Integer.valueOf(skip)).limit(Integer.valueOf(take)).includeAssets();
        SearchRequest request = requestBuilder.build();
        return this.searchService.search(request).getSearchResults();
    }

    public List<ComponentSearchResult> search(NugetV3SearchParam searchParam) {
        List<ComponentSearchResult> resultsBucket;
        int searchBorderIndex = searchParam.getSkip() + searchParam.getTake();
        HashSet<String> aggregatedResult = new HashSet<String>();
        List<Object> results = new ArrayList<ComponentSearchResult>();
        int bucketNumber = 0;
        do {
            resultsBucket = this.doSearch(QueryTerms.extract(searchParam.getQ()), this.maxBucketSize * bucketNumber, this.maxBucketSize);
            for (ComponentSearchResult result : resultsBucket) {
                aggregatedResult.add(result.getName());
                if (aggregatedResult.size() > searchBorderIndex) break;
                if (aggregatedResult.size() <= searchParam.getSkip()) continue;
                results.add(result);
            }
            ++bucketNumber;
        } while (resultsBucket.size() == this.maxBucketSize && aggregatedResult.size() <= searchBorderIndex);
        if (!searchParam.getPrerelease() && !results.isEmpty()) {
            results = results.stream().filter(NugetV3SearchFacet::isRelease).collect(Collectors.toList());
        }
        return results;
    }

    private static boolean isRelease(ComponentSearchResult result) {
        return result.getAssets().stream().findAny().map(AssetSearchResult::getAttributes).map(attr -> attr.get("nuget")).filter(Map.class::isInstance).map(Map.class::cast).map(nugetAttr -> nugetAttr.get("is_prerelease")).filter(Boolean.class::isInstance).map(Boolean.class::cast).orElse(false) == false;
    }

    @VisibleForTesting
    SearchRequest.Builder buildQuery(QueryTerms queryTerms) {
        List<Term> terms = queryTerms.getTerms().stream().filter(term -> this.fields.containsKey(term.getProperty())).collect(Collectors.toList());
        SearchRequest.Builder request = SearchRequest.builder();
        if (terms.isEmpty() && queryTerms.getKeywords().isEmpty()) {
            return request;
        }
        List uniqueProperties = terms.stream().map(Term::getProperty).distinct().collect(Collectors.toList());
        if (uniqueProperties.size() != terms.size()) {
            request.disjunction();
        }
        terms.forEach(term -> {
            String property = term.getProperty();
            String elasticProperty = this.fields.get(property);
            if (this.exactFields.containsKey(property)) {
                request.searchFilter(elasticProperty, term.getTerm());
            } else {
                request.searchFilter(elasticProperty, String.format(this.wildcardPattern, term.getTerm()));
            }
        });
        Set<String> keywords = queryTerms.getKeywords();
        if (CollectionUtils.isEmpty(terms) && CollectionUtils.isNotEmpty(keywords)) {
            request.disjunction();
            queryTerms.getKeywords().stream().map(searchKeyword -> String.format(this.wildcardPattern, searchKeyword)).forEach(term -> this.keywordsFields.forEach(field -> {
                SearchRequest.Builder builder2 = request.searchFilter(field, term);
            }));
        }
        return request.includeAssets();
    }

    public static class QueryTerms {
        private static final Pattern TERM_PATTERN = Pattern.compile("(?:^|\\s)(?:([^:\"\\s]*):)?([^\\s]+)");
        public static final QueryTerms EMPTY = new QueryTerms(Collections.emptySet(), Collections.emptyList());
        private final Set<String> keywords;
        private final List<Term> terms;

        private QueryTerms(Set<String> keywords, List<Term> terms) {
            Objects.requireNonNull(keywords, "Keywords is required");
            Objects.requireNonNull(terms, "Terms is required");
            this.keywords = keywords;
            this.terms = terms;
        }

        public Set<String> getKeywords() {
            return this.keywords;
        }

        public List<Term> getTerms() {
            return this.terms;
        }

        public static QueryTerms extract(@Nullable String q) {
            if (StringUtils.isEmpty((CharSequence)q)) {
                return EMPTY;
            }
            Matcher termMatcher = TERM_PATTERN.matcher(q);
            LinkedHashSet<String> searchKeywords = new LinkedHashSet<String>();
            ArrayList<Term> terms = new ArrayList<Term>();
            while (termMatcher.find()) {
                String term;
                String property = termMatcher.group(1);
                if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{property, term = QueryTerms.removeQuoteMark(termMatcher.group(2))})) {
                    String propertyLower = property.toLowerCase();
                    terms.add(new Term(propertyLower, term));
                    continue;
                }
                if (!StringUtils.isNotEmpty((CharSequence)term) || term.endsWith(":")) continue;
                searchKeywords.add(term);
            }
            return new QueryTerms(searchKeywords, terms);
        }

        private static String removeQuoteMark(@Nullable String value) {
            if (StringUtils.isEmpty((CharSequence)value)) {
                return value;
            }
            if (value.startsWith("\"")) {
                value = value.substring(1);
            }
            if (value.endsWith("\"")) {
                value = value.substring(0, value.length() - 1);
            }
            return value;
        }
    }

    public static class Term {
        private final String property;
        private final String term;

        public Term(String property, String term) {
            this.property = property;
            this.term = term;
        }

        public String getProperty() {
            return this.property;
        }

        public String getTerm() {
            return this.term;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Term term1 = (Term)o;
            return Objects.equals(this.property, term1.property) && Objects.equals(this.term, term1.term);
        }

        public int hashCode() {
            return Objects.hash(this.property, this.term);
        }
    }
}

