/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.internal.v3;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sonatype.nexus.repository.nuget.internal.v3.NugetV3ProxyUtil;
import com.sonatype.nexus.repository.nuget.v3.AssetKind;
import com.sonatype.nexus.repository.nuget.v3.NugetV3ServiceIndexFacet;
import com.sonatype.nexus.repository.nuget.v3.models.PageLeaf;
import com.sonatype.nexus.repository.nuget.v3.models.RegistrationIndex;
import com.sonatype.nexus.repository.nuget.v3.models.RegistrationPage;
import com.sonatype.nexus.repository.nuget.v3.models.ServiceIndex;
import com.sonatype.nexus.repository.nuget.v3.models.ServiceResource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.collections.CollectionUtils;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.proxy.ProxyFacet;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Request;

@Singleton
@Named
public class NugetV3ProxyMetadataProvider {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public List<PageLeaf> getOriginalPageLeaves(Repository repository, ServiceResource serviceResource, String packageId) throws IOException {
        if (!serviceResource.getType().startsWith("RegistrationsBaseUrl")) {
            throw new IllegalArgumentException("Service resource is not metadata");
        }
        Optional<RegistrationIndex> registrationIndexOptional = this.getProxyOriginalRegistrationIndex(repository, serviceResource, packageId);
        if (!registrationIndexOptional.isPresent()) {
            return Collections.emptyList();
        }
        RegistrationIndex registrationIndex = registrationIndexOptional.get();
        ArrayList<PageLeaf> pageLeavesResult = new ArrayList<PageLeaf>();
        for (RegistrationPage page : registrationIndex.getPages()) {
            if (CollectionUtils.isNotEmpty(page.getLeaves())) {
                pageLeavesResult.addAll(page.getLeaves());
                continue;
            }
            if (page.getCount() <= 0 || !CollectionUtils.isEmpty(page.getLeaves())) continue;
            String remoteLinkRegistrationPageId = page.getId();
            List<PageLeaf> leaves = this.getPageLeavesFromRegistrationPage(repository, remoteLinkRegistrationPageId);
            pageLeavesResult.addAll(leaves);
        }
        return pageLeavesResult;
    }

    private List<PageLeaf> getPageLeavesFromRegistrationPage(Repository repository, String remoteLinkRegistrationPageId) throws IOException {
        String nxrmLinkRegistrationPageId = NugetV3ProxyUtil.rewritePageId(remoteLinkRegistrationPageId, ((NugetV3ServiceIndexFacet)repository.facet(NugetV3ServiceIndexFacet.class)).getServiceIndex());
        String requestPath = nxrmLinkRegistrationPageId.replaceAll(repository.getUrl(), "");
        return this.getProxyOriginalRegistrationPage(repository, requestPath).map(registrationPage -> registrationPage.getLeaves()).orElse(Collections.emptyList());
    }

    private Optional<RegistrationIndex> getProxyOriginalRegistrationIndex(Repository repository, ServiceResource serviceResource, String packageId) throws IOException {
        String registrationIndexRequestPath = NugetV3ProxyUtil.buildRelativeRegistrationIndexNxrmRequestPath(repository.getUrl(), serviceResource.getId(), packageId);
        Context context = new Context(repository, new Request.Builder().action("GET").path(registrationIndexRequestPath).build());
        context.getAttributes().set(AssetKind.class, (Object)AssetKind.REGISTRATION_INDEX);
        context.getAttributes().set(ServiceIndex.class, (Object)((NugetV3ServiceIndexFacet)repository.facet(NugetV3ServiceIndexFacet.class)).getServiceIndex());
        context.getAttributes().set("registrationPackageId", (Object)packageId);
        context.getAttributes().set("RETURNS_ORIGINAL_CONTENT", (Object)true);
        Content content = ((ProxyFacet)repository.facet(ProxyFacet.class)).get(context);
        if (content == null) {
            return Optional.empty();
        }
        RegistrationIndex registrationIndex = (RegistrationIndex)OBJECT_MAPPER.readValue(content.openInputStream(), RegistrationIndex.class);
        return Optional.of(registrationIndex);
    }

    private Optional<RegistrationPage> getProxyOriginalRegistrationPage(Repository repository, String registrationPageRequestPath) throws IOException {
        Context context = new Context(repository, new Request.Builder().action("GET").path(registrationPageRequestPath).build());
        context.getAttributes().set(AssetKind.class, (Object)AssetKind.REGISTRATION_PAGE);
        context.getAttributes().set(ServiceIndex.class, (Object)((NugetV3ServiceIndexFacet)repository.facet(NugetV3ServiceIndexFacet.class)).getServiceIndex());
        context.getAttributes().set("registrationPage", (Object)NugetV3ProxyUtil.extractRelativeRegistrationPagePath(registrationPageRequestPath));
        context.getAttributes().set("RETURNS_ORIGINAL_CONTENT", (Object)true);
        Content content = ((ProxyFacet)repository.facet(ProxyFacet.class)).get(context);
        if (content == null) {
            return Optional.empty();
        }
        RegistrationPage page = (RegistrationPage)OBJECT_MAPPER.readValue(content.openInputStream(), RegistrationPage.class);
        return Optional.of(page);
    }
}

