/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.internal.v3;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sonatype.nexus.repository.nuget.internal.v3.NugetV3HostedSearchResponseProcessor;
import com.sonatype.nexus.repository.nuget.internal.v3.NugetV3SearchFacet;
import com.sonatype.nexus.repository.nuget.internal.v3.NugetV3SearchParam;
import com.sonatype.nexus.repository.nuget.v3.models.SearchResponse;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.sonatype.nexus.repository.search.ComponentSearchResult;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.Status;
import org.sonatype.nexus.repository.view.payloads.StringPayload;
import org.sonatype.nexus.rest.ValidationErrorXO;
import org.sonatype.nexus.rest.ValidationErrorsException;

public class NugetV3HostedSearchHandler
implements Handler {
    @Inject
    private ObjectMapper objectMapper;

    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        NugetV3SearchParam searchParam = NugetV3SearchParam.build(context.getRequest().getParameters());
        try {
            List<ComponentSearchResult> hits = ((NugetV3SearchFacet)context.getRepository().facet(NugetV3SearchFacet.class)).search(searchParam);
            SearchResponse searchResponse = NugetV3HostedSearchResponseProcessor.process(context.getRepository().getUrl(), hits);
            String json = this.objectMapper.writeValueAsString((Object)searchResponse);
            return new Response.Builder().status(Status.success((int)200)).payload((Payload)new StringPayload(json, "application/json")).build();
        }
        catch (ValidationErrorsException e) {
            String message = e.getValidationErrors().stream().map(ValidationErrorXO::getMessage).collect(Collectors.joining("\n"));
            return new Response.Builder().status(Status.failure((int)400, (String)message)).build();
        }
    }
}

