/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.internal.v3;

import com.google.common.annotations.VisibleForTesting;
import com.sonatype.nexus.repository.nuget.internal.v3.NugetV3ProxyUtil;
import com.sonatype.nexus.repository.nuget.v3.NugetV3ServiceIndexFacet;
import com.sonatype.nexus.repository.nuget.v3.models.SearchResponse;
import com.sonatype.nexus.repository.nuget.v3.models.SearchResult;
import com.sonatype.nexus.repository.nuget.v3.models.SearchResultVersion;
import com.sonatype.nexus.repository.nuget.v3.models.ServiceIndex;
import com.sonatype.nexus.repository.nuget.v3.models.ServiceResource;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.FacetSupport;

@Named
@Facet.Exposed
public class NugetV3GroupSearchFacet
extends FacetSupport {
    private static final Pattern REGISTRATION_URL_PATTERN = Pattern.compile("(.+)/(.+)/(.+\\.json)");

    public SearchResponse mergeResponse(List<Pair<String, SearchResponse>> responses, int skip, int take) throws IOException {
        ServiceIndex serviceIndex = ((NugetV3ServiceIndexFacet)this.facet(NugetV3ServiceIndexFacet.class)).getServiceIndex();
        List<SearchResult> searchResults = this.mergeSearchResults(responses, serviceIndex, skip, take);
        SearchResponse searchResponse = new SearchResponse();
        searchResponse.setTotalHits(searchResults.size());
        searchResponse.setData(searchResults);
        return searchResponse;
    }

    @VisibleForTesting
    protected List<SearchResult> mergeSearchResults(List<Pair<String, SearchResponse>> searchResponses, ServiceIndex serviceIndex, int skip, int take) {
        return searchResponses.stream().flatMap(searchResult -> ((SearchResponse)searchResult.getValue()).getData().stream()).map(searchResult -> this.rewriteRegistrationInSearchResult(serviceIndex, (SearchResult)searchResult)).collect(Collectors.toMap(SearchResult::getId, Function.identity(), this::mergeVersions, LinkedHashMap::new)).values().stream().skip(skip).limit(take).collect(Collectors.toList());
    }

    private SearchResult rewriteRegistrationInSearchResult(ServiceIndex serviceIndex, SearchResult searchResult) {
        String remoteUrl = searchResult.getRegistration();
        String registrationUrl = this.createRegistrationUrlGroup(this.getRepository().getName(), remoteUrl, serviceIndex);
        searchResult.setRegistration(registrationUrl);
        searchResult.getVersions().forEach(version -> {
            String versionRemoteUrl = version.getId();
            String versionRegistrationUrl = this.createRegistrationUrlGroup(this.getRepository().getName(), versionRemoteUrl, serviceIndex);
            version.setId(versionRegistrationUrl);
        });
        return searchResult;
    }

    private SearchResult mergeVersions(SearchResult v1, SearchResult v2) {
        List<SearchResultVersion> mergedVersions = Stream.concat(v1.getVersions().stream(), v2.getVersions().stream()).distinct().collect(Collectors.toList());
        v1.setVersions(mergedVersions);
        return v1;
    }

    private String createRegistrationUrlGroup(String repositoryName, String remoteUrl, ServiceIndex serviceIndex) {
        if (StringUtils.isBlank((CharSequence)remoteUrl)) {
            return null;
        }
        Matcher matcher = REGISTRATION_URL_PATTERN.matcher(remoteUrl);
        if (matcher.find()) {
            String suffix = matcher.group(2);
            String extension = matcher.group(3);
            Optional registrationService = serviceIndex.resourcesByName("RegistrationsBaseUrl").stream().findFirst();
            if (registrationService.isPresent()) {
                return NugetV3ProxyUtil.joinPath(((ServiceResource)registrationService.get()).getId(), suffix, extension);
            }
        }
        this.log.warn("Unable to rewrite registration URL for: {} on repository: {}. No service found for registration URL: {}", new Object[]{remoteUrl, repositoryName, remoteUrl});
        return remoteUrl;
    }
}

