/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.internal.v3;

import com.sonatype.nexus.repository.nuget.internal.exception.InvalidServiceIndexException;
import com.sonatype.nexus.repository.nuget.internal.v3.NugetV3ProxyUtil;
import com.sonatype.nexus.repository.nuget.v3.NugetServiceType;
import com.sonatype.nexus.repository.nuget.v3.NugetV3ServiceIndexFacet;
import com.sonatype.nexus.repository.nuget.v3.PackageBaseAddress;
import com.sonatype.nexus.repository.nuget.v3.models.RegistrationLeaf;
import com.sonatype.nexus.repository.nuget.v3.models.ServiceIndex;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import javax.inject.Named;
import org.apache.commons.lang3.tuple.Pair;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.Repository;

@Named
@Facet.Exposed
public class NugetV3GroupRegistrationLeafFacet
extends FacetSupport {
    public RegistrationLeaf mergeResponses(List<Pair<Repository, RegistrationLeaf>> responses, NugetServiceType nugetServiceType) {
        return responses.stream().map(leafPair -> {
            ServiceIndex serviceIndex;
            Repository repository = (Repository)leafPair.getKey();
            RegistrationLeaf registrationLeaf = (RegistrationLeaf)leafPair.getValue();
            try {
                serviceIndex = ((NugetV3ServiceIndexFacet)repository.facet(NugetV3ServiceIndexFacet.class)).getServiceIndex();
            }
            catch (IOException e) {
                this.log.warn(e.getMessage(), (Throwable)e);
                return null;
            }
            this.rewriteLeaf(repository, registrationLeaf, serviceIndex, nugetServiceType);
            return registrationLeaf;
        }).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private void rewriteLeaf(Repository repository, RegistrationLeaf pageLeaf, ServiceIndex serviceIndex, NugetServiceType groupServiceType) {
        String sourceRegistrationUrl;
        try {
            sourceRegistrationUrl = serviceIndex.resourceIdByTypeTrimSlashes(groupServiceType);
        }
        catch (InvalidServiceIndexException invalidServiceIndexException) {
            this.log.debug("NuGet Repository {} is missing service {} in ServiceIndex, trying a fallback source registration URL", (Object)repository.getName(), (Object)groupServiceType.getType());
            sourceRegistrationUrl = NugetV3ProxyUtil.joinPath(repository.getUrl(), NugetV3ProxyUtil.trimSlashes(groupServiceType.getPath()));
        }
        String groupRegistrationUrl = NugetV3ProxyUtil.joinPath(this.getRepository().getUrl(), groupServiceType.getPath());
        pageLeaf.setId(pageLeaf.getId().replace(sourceRegistrationUrl, groupRegistrationUrl));
        if (pageLeaf.getPackageContent() != null) {
            String sourceContentUrl;
            try {
                sourceContentUrl = serviceIndex.resourceIdByTypeTrimSlashes(PackageBaseAddress.PACKAGE_BASE_ADDRESS);
            }
            catch (InvalidServiceIndexException invalidServiceIndexException) {
                this.log.debug("NuGet Repository {} is missing service {} in ServiceIndex, trying a fallback source content URL", (Object)repository.getName(), (Object)groupServiceType.getType());
                sourceContentUrl = NugetV3ProxyUtil.joinPath(repository.getUrl(), NugetV3ProxyUtil.trimSlashes(PackageBaseAddress.PACKAGE_BASE_ADDRESS.getPath()));
            }
            String groupContentUrl = NugetV3ProxyUtil.joinPath(this.getRepository().getUrl(), PackageBaseAddress.PACKAGE_BASE_ADDRESS.getPath());
            pageLeaf.setPackageContent(pageLeaf.getPackageContent().replace(sourceContentUrl, groupContentUrl));
        }
    }
}

