/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.internal.v3;

import com.sonatype.nexus.repository.nuget.internal.v3.NugetV3ProxyUtil;
import com.sonatype.nexus.repository.nuget.v3.NugetServiceType;
import com.sonatype.nexus.repository.nuget.v3.NugetV3ServiceIndexFacet;
import com.sonatype.nexus.repository.nuget.v3.models.AvailableVersions;
import com.sonatype.nexus.repository.nuget.v3.models.ServiceIndex;
import com.sonatype.nexus.repository.nuget.v3.models.ServiceResource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.tuple.Pair;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.VersionComparator;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.view.Context;

@Named
@Singleton
public class NugetV3GroupHelper
extends ComponentSupport {
    public List<Pair<Repository, List<String>>> getMembersRequestPaths(String requestPath, NugetServiceType serviceType, List<Repository> members) {
        List<Pair<Repository, List<String>>> membersServiceTypePaths = this.getMembersServiceTypePaths(serviceType, members);
        String requestPathSuffix = this.getRequestPathSuffix(requestPath, serviceType);
        return membersServiceTypePaths.stream().map(pair -> {
            List paths = (List)pair.getValue();
            List requestPaths = paths.stream().map(path -> this.toRequestPath((String)path, requestPathSuffix)).collect(Collectors.toList());
            return Pair.of((Object)((Repository)pair.getKey()), requestPaths);
        }).collect(Collectors.toList());
    }

    private String toRequestPath(String path, String requestPathSuffix) {
        return "/" + NugetV3ProxyUtil.joinPath(path, requestPathSuffix);
    }

    public String getRequestPathSuffix(String requestPath, NugetServiceType serviceType) {
        String serviceTypePath = serviceType.getPath();
        if (!requestPath.startsWith(serviceTypePath)) {
            throw new IllegalArgumentException(String.format("Request path %s does not start with service type path %s", requestPath, serviceTypePath));
        }
        return requestPath.substring(serviceTypePath.length());
    }

    public List<Pair<Repository, List<String>>> getMembersServiceTypePaths(NugetServiceType serviceType, List<Repository> members) {
        return members.stream().map(member -> Pair.of((Object)member, this.getPaths((Repository)member, serviceType))).collect(Collectors.toList());
    }

    private List<String> getPaths(Repository member, NugetServiceType serviceType) {
        Objects.requireNonNull(member);
        return this.getPathsByGivenServiceType(member, serviceType).map(path -> this.transformEmptyPathsList(member, serviceType, (List<String>)path)).orElseGet(() -> this.reportMissingServiceIndex(member));
    }

    private List<String> reportMissingServiceIndex(Repository member) {
        this.log.debug("ServiceIndex is missing in the repository {}", (Object)member.getName());
        return Collections.emptyList();
    }

    private List<String> transformEmptyPathsList(Repository member, NugetServiceType serviceType, List<String> path) {
        if (path.isEmpty()) {
            this.log.debug("NuGet Repository {} is missing service {} in ServiceIndex, trying a fallback service path", (Object)member.getName(), (Object)serviceType.getType());
            return Collections.singletonList(serviceType.getPath());
        }
        return path;
    }

    public Optional<ServiceIndex> getServiceIndex(Repository repository) {
        NugetV3ServiceIndexFacet serviceIndexFacet = (NugetV3ServiceIndexFacet)repository.facet(NugetV3ServiceIndexFacet.class);
        try {
            ServiceIndex serviceIndex = serviceIndexFacet.getServiceIndex();
            return Optional.of(serviceIndex);
        }
        catch (IOException e) {
            String repositoryName = repository.getName();
            this.log.warn("Error retrieving service index for the repository {}", (Object)repositoryName, (Object)e);
            return Optional.empty();
        }
    }

    public AvailableVersions mergeAvailableVersions(Collection<AvailableVersions> availableVersions) {
        Set versions = availableVersions.stream().flatMap(v -> v.getVersions().stream()).collect(Collectors.toCollection(() -> new TreeSet(VersionComparator.INSTANCE)));
        AvailableVersions result = new AvailableVersions();
        result.setVersions(new ArrayList<String>(versions));
        return result;
    }

    public List<Pair<Repository, List<String>>> buildMetadataRequests(NugetServiceType nugetServiceType, List<Repository> members, Context context) {
        Map<String, List<String>> membersServiceTypePaths = this.getMembersServiceTypePathsByGivenServicePath(nugetServiceType, members);
        String requestPathSuffix = this.getRequestPathSuffix(context.getRequest().getPath(), nugetServiceType);
        ArrayList<Pair<Repository, List<String>>> requestLists = new ArrayList<Pair<Repository, List<String>>>();
        for (Repository member : members) {
            List<String> requestPaths = membersServiceTypePaths.get(member.getName());
            if (requestPaths.isEmpty()) {
                requestPaths = this.buildAlternativeRequests(member, nugetServiceType);
            }
            requestPaths = this.completePathsWithSuffix(requestPaths, requestPathSuffix);
            requestLists.add((Pair<Repository, List<String>>)Pair.of((Object)member, requestPaths));
        }
        return requestLists;
    }

    private List<String> completePathsWithSuffix(List<String> paths, String suffix) {
        return paths.stream().map(path -> this.toRequestPath((String)path, suffix)).collect(Collectors.toList());
    }

    protected List<String> buildAlternativeRequests(Repository member, NugetServiceType nugetServiceType) {
        List<String> allPossibleResourceType = Arrays.asList("RegistrationsBaseUrl/Versioned", "RegistrationsBaseUrl/3.6.0", "RegistrationsBaseUrl/3.4.0", "RegistrationsBaseUrl", "RegistrationsBaseUrl/3.0.0-rc", "RegistrationsBaseUrl/3.0.0-beta");
        List resourceTypesThatCanBeAskedAsAlternative = allPossibleResourceType.stream().filter(resourceType -> resourceType.equals(nugetServiceType.getType())).collect(Collectors.toList());
        ServiceIndex serviceIndex = this.getServiceIndex(member).orElse(null);
        List<String> possiblePaths = new ArrayList<String>();
        if (serviceIndex != null && (possiblePaths = serviceIndex.getResources().stream().filter(serviceResource -> resourceTypesThatCanBeAskedAsAlternative.contains(serviceResource.getType())).map(serviceResource -> this.getResourceUrl(member, (ServiceResource)serviceResource)).collect(Collectors.toList())).isEmpty()) {
            String alternativeUrl = serviceIndex.getResources().stream().filter(resource -> allPossibleResourceType.contains(resource.getType())).findFirst().map(serviceResource -> this.getResourceUrl(member, (ServiceResource)serviceResource)).orElse("");
            possiblePaths.add(alternativeUrl);
        }
        return possiblePaths;
    }

    private String getResourceUrl(Repository member, ServiceResource serviceResource) {
        String resourceID = serviceResource.getId();
        String url = member.getUrl();
        return resourceID.replaceAll(url, "");
    }

    private Map<String, List<String>> getMembersServiceTypePathsByGivenServicePath(NugetServiceType nugetServiceType, List<Repository> members) {
        return members.stream().collect(Collectors.toMap(Repository::getName, member -> this.getPathsByGivenServiceType((Repository)member, nugetServiceType).orElseGet(() -> this.reportMissingServiceIndex((Repository)member))));
    }

    private Optional<List<String>> getPathsByGivenServiceType(Repository member, NugetServiceType nugetServiceType) {
        Objects.requireNonNull(member);
        Objects.requireNonNull(nugetServiceType);
        return this.getServiceIndex(member).map(ServiceIndex::getResources).map(serviceResources -> this.processServiceResources(member, nugetServiceType, (List<ServiceResource>)serviceResources));
    }

    private List<String> processServiceResources(Repository member, NugetServiceType nugetServiceType, List<ServiceResource> serviceResources) {
        return serviceResources.stream().filter(serviceResource -> nugetServiceType.getType().equals(serviceResource.getType())).map(serviceResource -> this.getResourceUrl(member, (ServiceResource)serviceResource)).collect(Collectors.toList());
    }
}

