/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.internal.v3;

import com.sonatype.nexus.repository.nuget.internal.v3.NugetV3GroupHelper;
import com.sonatype.nexus.repository.nuget.v3.NugetServiceType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.group.GroupFacet;
import org.sonatype.nexus.repository.group.GroupHandler;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.Response;

public abstract class NugetV3GroupAbstractHandler
extends GroupHandler {
    protected final NugetV3GroupHelper nugetV3GroupHelper;

    protected NugetV3GroupAbstractHandler(NugetV3GroupHelper nugetV3GroupHelper) {
        this.nugetV3GroupHelper = nugetV3GroupHelper;
    }

    protected abstract Response doGet(@Nonnull Context var1, @Nonnull GroupHandler.DispatchedRepositories var2) throws Exception;

    protected List<Pair<Repository, Payload>> getRepositoryPayloads(@Nonnull Context context, @Nonnull GroupHandler.DispatchedRepositories dispatched) throws Exception {
        ArrayList<Pair<Repository, Payload>> responses = new ArrayList<Pair<Repository, Payload>>();
        List<Pair<Repository, List<Request>>> listOfRequests = this.createRequestsToMembers(context);
        for (Pair<Repository, List<Request>> pair : listOfRequests) {
            Repository member = (Repository)pair.getKey();
            List requests = (List)pair.getValue();
            for (Request request : requests) {
                Context requestContext = new Context(member, request);
                requestContext.getAttributes().backing().putAll(context.getAttributes().backing());
                Response response = this.getFromRepository(requestContext, dispatched);
                if (!this.isValidResponse(response)) continue;
                responses.add((Pair<Repository, Payload>)Pair.of((Object)member, (Object)response.getPayload()));
            }
        }
        return responses;
    }

    @Nullable
    protected Response getFirstSuccessfulResponse(@Nonnull Context context, @Nonnull GroupHandler.DispatchedRepositories dispatched) throws Exception {
        List<Pair<Repository, List<Request>>> listOfRequests = this.createRequestsToMembers(context);
        for (Pair<Repository, List<Request>> pair : listOfRequests) {
            Repository member = (Repository)pair.getKey();
            List requests = (List)pair.getValue();
            for (Request request : requests) {
                Context requestContext = new Context(member, request);
                requestContext.getAttributes().backing().putAll(context.getAttributes().backing());
                Response response = this.getFromRepository(requestContext, dispatched);
                if (!this.isValidResponse(response)) continue;
                return response;
            }
        }
        return null;
    }

    protected Response notFound() {
        return HttpResponses.notFound((String)"The specified blob does not exist.");
    }

    protected List<Pair<Repository, List<Request>>> createRequestsToMembers(Context context) {
        NugetServiceType nugetServiceType = (NugetServiceType)context.getAttributes().get(NugetServiceType.class);
        GroupFacet groupFacet = (GroupFacet)context.getRepository().facet(GroupFacet.class);
        Request request = context.getRequest();
        List<Pair<Repository, List<String>>> membersRequestPaths = this.nugetV3GroupHelper.getMembersRequestPaths(request.getPath(), nugetServiceType, groupFacet.members());
        return this.getRequestsFromStringPaths(context, membersRequestPaths);
    }

    protected List<Pair<Repository, List<Request>>> getRequestsFromStringPaths(Context context, List<Pair<Repository, List<String>>> membersRequestPaths) {
        return membersRequestPaths.stream().map(pair -> {
            List requestPaths = (List)pair.getValue();
            List<Request> requests = this.getRequestsFromRequestPaths(context.getRequest(), requestPaths);
            return Pair.of((Object)((Repository)pair.getKey()), requests);
        }).collect(Collectors.toList());
    }

    private List<Request> getRequestsFromRequestPaths(Request originalRequest, List<String> requestPaths) {
        return requestPaths.stream().map(requestPath -> new Request.Builder().copy(originalRequest).path(requestPath).build()).collect(Collectors.toList());
    }

    private Response getFromRepository(Context context, GroupHandler.DispatchedRepositories dispatched) throws Exception {
        Repository repository = context.getRepository();
        return super.getFirst(context, Collections.singletonList(repository), dispatched);
    }
}

