/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.internal.v3;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.sonatype.nexus.repository.view.Matcher;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;

public final class NugetRouteConstants {
    public static final String URL_PATH_SEPARATOR = "/";
    public static final String SERVICE_INDEX_NXRM_PATH = "/index.json";
    public static final String SEARCH_NXRM_PATH = "/v3/query/";
    public static final String SEARCH_ROUTE_TOKEN_PATTERN = "/v3/query/{id}";
    public static final String REGISTRATION_NXRM_PATH = "/v3/registration/";
    public static final String CATALOG_NXRM_PATH = "/v3/catalog/";
    public static final String PAGE_KEY = "page";
    public static final String CONTENT_NXRM_PATH = "/v3/content/";
    public static final String REPOSITORY_SIGNATURES_PATH = "/v3/repository-signatures/";
    public static final String REPOSITORY_SIGNATURES_CERTIFICATES_SUFFIX = "certificates";
    public static final String REPOSITORY_SIGNATURES_CERTIFICATES_CRT = ".crt";
    public static final Map<String, String> REWRITE_PATH_BY_RESOURCE = ImmutableMap.of((Object)"SearchQueryService", (Object)"/v3/query/", (Object)"RegistrationsBaseUrl", (Object)"/v3/registration/", (Object)"PackageBaseAddress", (Object)"/v3/content/");

    private NugetRouteConstants() {
    }

    public static Matcher getContentMatcher(String contentPathPrefix) {
        return new TokenMatcher(String.valueOf(contentPathPrefix) + "{package_id}/{package_version}/{package_id_plus_package_version}.nupkg");
    }

    public static Matcher getManifestMatcher(String manifestPathPrefix) {
        return new TokenMatcher(String.valueOf(manifestPathPrefix) + "{package_id}/{package_version}/{package_id_2}.nuspec");
    }

    public static Matcher getVersionsMatcher(String versionPathPrefix) {
        return new TokenMatcher(String.valueOf(versionPathPrefix) + "{package_id}/index.json");
    }

    public static Matcher getRegistrationIndexMatcher(String registrationIndexPrefix) {
        return new TokenMatcher(String.valueOf(registrationIndexPrefix) + "{package_id}/index.json");
    }

    public static Matcher getRegistrationLeafMatcher(String registrationIndexPrefix) {
        return new TokenMatcher(String.valueOf(registrationIndexPrefix) + "{package_id}/{package_version}.json");
    }
}

