/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.internal.v3;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sonatype.nexus.repository.nuget.NugetPackageCoords;
import com.sonatype.nexus.repository.nuget.internal.v3.packagemetadata.NugetRegistrationsFacet;
import com.sonatype.nexus.repository.nuget.internal.v3.routing.NugetMetadataMatcher;
import com.sonatype.nexus.repository.nuget.v3.models.RegistrationLeaf;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.payloads.StringPayload;

@Named
@Singleton
public class NugetRegistrationLeafHandler
implements Handler {
    private final ObjectMapper objectMapper;

    @Inject
    public NugetRegistrationLeafHandler(ObjectMapper objectMapper) {
        this.objectMapper = Objects.requireNonNull(objectMapper);
    }

    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        String metadataPath = NugetMetadataMatcher.getMetadataPath(context);
        NugetPackageCoords coords = this.getNugetPackageCoords(metadataPath);
        if (coords == null) {
            return HttpResponses.notFound((String)("Metadata path pattern is not \"id/version.json\" Current metadata path " + metadataPath));
        }
        Optional<RegistrationLeaf> registrationLeaf = ((NugetRegistrationsFacet)context.getRepository().facet(NugetRegistrationsFacet.class)).getRegistrationLeaf(coords);
        if (registrationLeaf.isPresent()) {
            return HttpResponses.ok((Payload)new StringPayload(this.objectMapper.writeValueAsString((Object)registrationLeaf.get()), "application/json"));
        }
        return HttpResponses.notFound();
    }

    @Nullable
    private NugetPackageCoords getNugetPackageCoords(String metadataPath) {
        String[] split = metadataPath.split("/");
        if (split.length != 2) {
            return null;
        }
        String id = split[0];
        String preVersion = split[1];
        String version = preVersion.substring(0, preVersion.length() - 5);
        return new NugetPackageCoords(id, version);
    }
}

