/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.internal.v3;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sonatype.nexus.repository.nuget.internal.v3.packagemetadata.NugetRegistrationsFacet;
import com.sonatype.nexus.repository.nuget.internal.v3.routing.NugetMetadataMatcher;
import com.sonatype.nexus.repository.nuget.v3.models.RegistrationIndex;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.Status;
import org.sonatype.nexus.repository.view.payloads.StringPayload;

@Named
@Singleton
public class NugetRegistrationIndexHandler
implements Handler {
    private final ObjectMapper objectMapper;

    @Inject
    public NugetRegistrationIndexHandler(ObjectMapper objectMapper) {
        this.objectMapper = Objects.requireNonNull(objectMapper);
    }

    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        Optional<RegistrationIndex> maybeIndex = ((NugetRegistrationsFacet)context.getRepository().facet(NugetRegistrationsFacet.class)).getRegistrationIndex(NugetMetadataMatcher.getMetadataPackageId(context));
        if (maybeIndex.isPresent()) {
            return new Response.Builder().status(Status.success((int)200)).payload((Payload)new StringPayload(this.objectMapper.writeValueAsString((Object)maybeIndex.get()), "application/json")).build();
        }
        return new Response.Builder().status(Status.failure((int)404)).build();
    }
}

