/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.internal.v3;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.ByteStreams;
import com.sonatype.nexus.repository.nuget.internal.v3.NugetV3ProxyUtil;
import com.sonatype.nexus.repository.nuget.v3.models.SearchResponse;
import com.sonatype.nexus.repository.nuget.v3.models.ServiceIndex;
import com.sonatype.nexus.repository.nuget.v3.models.ServiceResource;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.httpclient.HttpClientFacet;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.Status;
import org.sonatype.nexus.repository.view.payloads.BytesPayload;
import org.sonatype.nexus.repository.view.payloads.StringPayload;

public class NugetProxySearchHandler
extends ComponentSupport
implements Handler {
    private final ObjectMapper objectMapper;
    private static final Pattern REGISTRATION_URL_PATTERN = Pattern.compile("(.+)/(.+)/(.+\\.json)");

    @Inject
    public NugetProxySearchHandler(ObjectMapper objectMapper) {
        this.objectMapper = Objects.requireNonNull(objectMapper);
    }

    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        HttpResponse response = ((HttpClientFacet)context.getRepository().facet(HttpClientFacet.class)).getHttpClient().execute((HttpUriRequest)new HttpGet(this.getRemoteSearchUri(context)));
        StatusLine statusLine = response.getStatusLine();
        boolean isSuccessful = statusLine.getStatusCode() == 200;
        Response.Builder builder = new Response.Builder().status(new Status(isSuccessful, statusLine.getStatusCode(), statusLine.getReasonPhrase()));
        if (response.getEntity() != null) {
            builder.payload(isSuccessful ? this.createPayload(response, context) : this.getPayload(response));
        }
        return builder.build();
    }

    private Payload getPayload(HttpResponse response) throws IOException {
        return new BytesPayload(ByteStreams.toByteArray((InputStream)response.getEntity().getContent()), response.getEntity().getContentType().getValue());
    }

    private Payload createPayload(HttpResponse response, Context context) throws IOException {
        return new StringPayload(this.objectMapper.writeValueAsString((Object)this.rewriteRegistrationUrls(context.getRepository(), response.getEntity(), (ServiceIndex)context.getAttributes().require(ServiceIndex.class))), response.getEntity().getContentType().getValue());
    }

    private URI getRemoteSearchUri(Context context) {
        try {
            return NugetV3ProxyUtil.buildRemoteUri(context);
        }
        catch (URISyntaxException e) {
            this.log.error("Invalid search remote URL matched for NXRM path '{}'", (Object)context.getRequest().getPath(), (Object)e);
            throw new RuntimeException(e);
        }
    }

    private SearchResponse rewriteRegistrationUrls(Repository repository, HttpEntity entity, ServiceIndex serviceIndex) throws IOException {
        SearchResponse searchResponse = (SearchResponse)this.objectMapper.readValue(entity.getContent(), SearchResponse.class);
        searchResponse.getData().forEach(searchHit -> {
            searchHit.setRegistration(this.rewriteRegistrationUrl(repository, searchHit.getRegistration(), serviceIndex));
            searchHit.getVersions().forEach(version -> version.setId(this.rewriteRegistrationUrl(repository, version.getId(), serviceIndex)));
        });
        return searchResponse;
    }

    @Nullable
    private String rewriteRegistrationUrl(Repository repository, @Nullable String remoteUrl, ServiceIndex serviceIndex) {
        Optional<ServiceResource> registrationService;
        if (StringUtils.isBlank((CharSequence)remoteUrl)) {
            return null;
        }
        Matcher matcher = REGISTRATION_URL_PATTERN.matcher(remoteUrl);
        if (matcher.find() && (registrationService = serviceIndex.resourcesByName("RegistrationsBaseUrl").stream().filter(r -> matcher.group(1).equals(r.getRemoteUrl())).findFirst()).isPresent()) {
            return NugetV3ProxyUtil.joinPath(registrationService.get().getId(), matcher.group(2), matcher.group(3));
        }
        this.log.warn("Unable to rewrite registration URL for: {} on repository: {}. No service found for registration URL: {}", new Object[]{remoteUrl, repository.getName(), remoteUrl});
        return remoteUrl;
    }
}

