/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.internal.v3;

import com.sonatype.nexus.repository.nuget.internal.v3.NugetV3HostedFacet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.Status;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;
import org.sonatype.nexus.repository.view.payloads.StringPayload;

public class NugetPackageManifestHandler
extends ComponentSupport
implements Handler {
    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        String manifest;
        Map tokens = ((TokenMatcher.State)context.getAttributes().get(TokenMatcher.State.class)).getTokens();
        try {
            this.validateTokens(tokens, context.getRequest().getPath());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new Response.Builder().status(new Status(false, 404, "The specified blob does not exist.")).build();
        }
        String packageId = (String)tokens.get("package_id");
        String version = (String)tokens.get("package_version");
        Optional<Content> content = ((NugetV3HostedFacet)context.getRepository().facet(NugetV3HostedFacet.class)).getAssetContent(packageId, version);
        if (!content.isPresent()) {
            return new Response.Builder().status(new Status(false, 404, "The specified blob does not exist.")).build();
        }
        try {
            manifest = this.getManifestFromContent(content.get());
        }
        catch (IOException iOException) {
            String errorString = String.format("Internal error retrieving manifest file for package ID %s with version %s.", packageId, version);
            return new Response.Builder().status(new Status(false, 500, errorString)).build();
        }
        if (manifest != null) {
            StringPayload plainTextPayload = new StringPayload(manifest, "application/xml");
            return new Response.Builder().status(new Status(true, 200)).payload((Payload)plainTextPayload).build();
        }
        return new Response.Builder().status(new Status(false, 404, "The specified blob does not exist.")).build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getManifestFromContent(Content content) throws IOException {
        String manifest = null;
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            InputStream inputStream = content.openInputStream();
            try {
                try (ZipInputStream zis = new ZipInputStream(inputStream);){
                    ZipEntry entry;
                    while ((entry = zis.getNextEntry()) != null) {
                        if (!entry.getName().endsWith(".nuspec")) continue;
                        manifest = IOUtils.toString((InputStream)zis, (Charset)StandardCharsets.UTF_8);
                        break;
                    }
                }
                if (inputStream == null) return manifest;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (inputStream == null) throw throwable;
                inputStream.close();
                throw throwable;
            }
            inputStream.close();
            return manifest;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private void validateTokens(Map<String, String> tokens, String path) {
        String packageId2;
        String packageId = tokens.get("package_id");
        if (!packageId.equals(packageId2 = tokens.get("package_id_2"))) {
            this.log.error("Requested package attributes do not match: " + path);
            throw new IllegalArgumentException();
        }
    }
}

