/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.nuget.internal.v2;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.sonatype.nexus.repository.nuget.internal.AbstractNugetHandler;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;

@Named
@Singleton
public class NugetV2EvaluateDeprecatedRequestHandler
extends AbstractNugetHandler {
    private static final List<String> VALID_ORDERBY_PARAMETERS = ImmutableList.of((Object)"Id", (Object)"Created", (Object)"DownloadCount", (Object)"Published", (Object)"LastEdited");

    @Override
    protected Response doHandle(Context context) throws Exception {
        String deprecatedReason = this.getDeprecatedReason(context);
        if (!Strings.isNullOrEmpty((String)deprecatedReason)) {
            context.getAttributes().set("NUGET_V2_DEPRECATED_REQUEST", (Object)deprecatedReason);
        }
        return context.proceed();
    }

    private String getDeprecatedReason(Context context) {
        String path = context.getRequest().getPath();
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().get(TokenMatcher.State.class);
        switch (state.pattern()) {
            case "/{operation:[^/()]+}{parens:\\\\Q()\\\\E|}": {
                String deprecated;
                String orderByParameter;
                if ("/Packages".equals(path) || "/Packages()".equals(path)) {
                    return "Packages";
                }
                if (!"/FindPackagesById()".equals(path) || (orderByParameter = context.getRequest().getParameters().get("$orderby")) == null || (deprecated = this.getDeprecatedOrderByParameter(orderByParameter)) == null) break;
                return "FindPackagesById: orderby=" + deprecated;
            }
            case "/{operation:[^/()]+}{parens:\\\\Q()\\\\E|}/$count": {
                if (!path.startsWith("/Packages")) break;
                return "Packages: count";
            }
            case "/Packages(Id='{id}',Version='{version}')": {
                String deprecated;
                String orderByParameter = context.getRequest().getParameters().get("$orderby");
                if (orderByParameter == null || (deprecated = this.getDeprecatedOrderByParameter(orderByParameter)) == null) break;
                return "Packages: orderby=" + deprecated;
            }
        }
        return null;
    }

    private String getDeprecatedOrderByParameter(String orderByParam) {
        String orderBy = this.cleanupOrderByParam(orderByParam);
        if (VALID_ORDERBY_PARAMETERS.contains(orderBy)) {
            return null;
        }
        return orderBy;
    }

    private String cleanupOrderByParam(String orderByParam) {
        String[] orderByParamSplit;
        if (((orderByParam = orderByParam.trim()).endsWith("asc") || orderByParam.endsWith("desc")) && (orderByParamSplit = orderByParam.split(" ")).length == 2) {
            return orderByParamSplit[0];
        }
        return orderByParam;
    }
}

